/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TownPortalScrollItem
extends Item {
    private static final TagKey<Structure> VILLAGE_TAG = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village"));
    private static final int CHANNEL_TICKS = 80;
    private static final int COOLDOWN_TICKS = 12000;
    private static final Logger LOGGER = LogManager.getLogger();

    public TownPortalScrollItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack p_41454_, @NotNull LivingEntity p_344979_) {
        return 80;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"item.medieval.town_portal_scroll.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)"Cast Time: 4.0s").withStyle(ChatFormatting.GREEN));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!level.isClientSide) {
                double remainingSeconds = (double)remainingUseDuration / 20.0;
                String formattedTime = String.format("%.1f", remainingSeconds);
                player.displayClientMessage((Component)Component.literal((String)("Channeling: " + formattedTime + "s")), true);
            }
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        BlockPos nearestVillage;
        Optional<Vec3> respawnLocation;
        if (!(entity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ServerLevel serverLevel = player.serverLevel();
        boolean teleported = false;
        MutableComponent resultMessage = null;
        BlockPos respawnPos = player.getRespawnPosition();
        ServerLevel respawnLevel = player.server.getLevel(player.getRespawnDimension());
        if (respawnLevel != null && respawnPos != null && (respawnLocation = this.findRespawnLocation(respawnLevel, respawnPos, player.getRespawnAngle(), player.isRespawnForced())).isPresent()) {
            Vec3 pos = respawnLocation.get();
            player.teleportTo(respawnLevel, pos.x, pos.y, pos.z, player.getYRot(), player.getXRot());
            teleported = true;
            resultMessage = Component.translatable((String)"item.medieval.town_portal_scroll.teleport_bed").withStyle(ChatFormatting.GREEN);
        }
        if (!teleported && (nearestVillage = serverLevel.findNearestMapStructure(VILLAGE_TAG, player.blockPosition(), 64, false)) != null) {
            BlockPos safePos = this.findSafeSpawnLocation(serverLevel, nearestVillage);
            player.teleportTo(serverLevel, (double)safePos.getX() + 0.5, (double)safePos.getY() + 0.1, (double)safePos.getZ() + 0.5, player.getYRot(), player.getXRot());
            teleported = true;
            resultMessage = Component.translatable((String)"item.medieval.town_portal_scroll.teleport_village").withStyle(ChatFormatting.GREEN);
        }
        if (!teleported) {
            ServerLevel overworld = player.server.overworld();
            BlockPos worldSpawn = overworld.getSharedSpawnPos();
            player.teleportTo(overworld, (double)worldSpawn.getX() + 0.5, (double)worldSpawn.getY() + 0.1, (double)worldSpawn.getZ() + 0.5, player.getYRot(), player.getXRot());
            teleported = true;
            resultMessage = Component.translatable((String)"item.medieval.town_portal_scroll.teleport_world_spawn").withStyle(ChatFormatting.GREEN);
        }
        if (teleported) {
            serverLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 0.75f);
            player.getCooldowns().addCooldown((Item)this, 12000);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        if (resultMessage != null) {
            player.displayClientMessage(resultMessage, true);
        }
        return stack;
    }

    private Optional<Vec3> findRespawnLocation(ServerLevel level, BlockPos pos, float angle, boolean forced) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof RespawnAnchorBlock && (forced || (Integer)blockState.getValue((Property)RespawnAnchorBlock.CHARGE) > 0) && RespawnAnchorBlock.canSetSpawn((Level)level)) {
            return RespawnAnchorBlock.findStandUpPosition((EntityType)EntityType.PLAYER, (CollisionGetter)level, (BlockPos)pos);
        }
        if (block instanceof BedBlock && BedBlock.canSetSpawn((Level)level)) {
            return BedBlock.findStandUpPosition((EntityType)EntityType.PLAYER, (CollisionGetter)level, (BlockPos)pos, (Direction)((Direction)blockState.getValue((Property)BedBlock.FACING)), (float)angle);
        }
        if (forced) {
            boolean flag = block.isPossibleToRespawnInThis(blockState);
            BlockState blockState1 = level.getBlockState(pos.above());
            boolean flag1 = blockState1.getBlock().isPossibleToRespawnInThis(blockState1);
            if (flag && flag1) {
                return Optional.of(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5));
            }
        }
        return Optional.empty();
    }

    private boolean isSafeSpawn(ServerLevel level, BlockPos pos) {
        if (!level.getBlockState(pos).isAir() || !level.getBlockState(pos.above()).isAir()) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
        while (mutable.getY() < level.getMaxBuildHeight()) {
            BlockState state = level.getBlockState((BlockPos)mutable);
            if (!state.isAir() && !state.liquid()) {
                return false;
            }
            mutable.move(Direction.UP);
        }
        return level.getBlockState(pos.below()).isSolid();
    }

    private BlockPos findSafeSpawnLocation(ServerLevel level, BlockPos start) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(start.getX(), Math.min(level.getMaxBuildHeight(), start.getY() + 10), start.getZ());
        while (mutable.getY() > level.getMinBuildHeight()) {
            BlockPos below = mutable.below();
            BlockState belowState = level.getBlockState(below);
            if (belowState.isSolid()) {
                if (!this.isSafeSpawn(level, (BlockPos)mutable)) break;
                return mutable.immutable();
            }
            mutable.move(Direction.DOWN);
        }
        mutable.set(start.getX(), start.getY(), start.getZ());
        while (mutable.getY() < level.getMaxBuildHeight() - 1) {
            if (this.isSafeSpawn(level, (BlockPos)mutable)) {
                return mutable.immutable();
            }
            mutable.move(Direction.UP);
        }
        return start;
    }
}

