/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval;

import dev.muon.medieval.Medieval;
import dev.muon.medieval.config.MedievalConfig;
import dev.muon.medieval.item.ItemRegistry;
import dev.muon.medieval.item.ItemRegistryNeoForge;
import dev.muon.medieval.platform.MedievalPlatformHelperNeoForge;
import dev.muon.medieval.platform.Services;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="medieval")
public class MedievalNeoForge {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"medieval");

    public MedievalNeoForge(IEventBus eventBus) {
        Medieval.init();
        Medieval.setHelper(new MedievalPlatformHelperNeoForge());
        Services.setup(new MedievalPlatformHelperNeoForge());
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MedievalConfig.COMMON_SPEC);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MedievalConfig.CLIENT_SPEC);
        ItemRegistryNeoForge.init(eventBus);
        this.registerCreativeTabs();
        CREATIVE_MODE_TABS.register(eventBus);
    }

    public boolean isModLoaded(String modId) {
        if (ModList.get() == null) {
            return LoadingModList.get().getMods().stream().map(ModInfo::getModId).anyMatch(modId::equals);
        }
        return ModList.get().isLoaded(modId);
    }

    private void registerCreativeTabs() {
        CREATIVE_MODE_TABS.register("medieval_tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ItemRegistry.CHALLENGE_ORB)).title((Component)Component.translatable((String)"itemGroup.medieval")).displayItems((parameters, output) -> {
            output.accept((ItemLike)ItemRegistry.CHALLENGE_ORB);
            output.accept((ItemLike)ItemRegistry.TOWN_PORTAL_SCROLL);
        }).build());
    }
}

