/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.mixin.compat.apothic_compats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DynamicRegistry.class}, remap=false)
public class DynamicRegistryMixin {
    @Unique
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Medieval/DynamicRegistryMixin");
    @Shadow
    @Final
    protected String path;
    @Unique
    private static final Set<String> DISABLED_CATEGORIES = Set.of("apothic_compats:bracelet", "apothic_compats:body", "apothic_compats:belt", "apothic_compats:charm", "apothic_compats:back", "apothic_compats:head", "apothic_compats:feet", "apothic_compats:curio");
    @Unique
    private static final Set<String> REGISTRIES_TO_FILTER = Set.of("extra_gem_bonuses", "affixes", "affix_loot_entries");

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void medieval$filterDisabledCategories(Map<ResourceLocation, JsonElement> objects, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        if (!REGISTRIES_TO_FILTER.contains(this.path)) {
            return;
        }
        LOGGER.debug("[Medieval] Filtering disabled loot categories from {} registry ({} entries)", (Object)this.path, (Object)objects.size());
        Iterator<Map.Entry<ResourceLocation, JsonElement>> mapIterator = objects.entrySet().iterator();
        while (mapIterator.hasNext()) {
            int removed;
            Map.Entry<ResourceLocation, JsonElement> entry = mapIterator.next();
            JsonElement element = entry.getValue();
            if (!element.isJsonObject()) continue;
            JsonObject json = element.getAsJsonObject();
            if ("extra_gem_bonuses".equals(this.path)) {
                removed = DynamicRegistryMixin.medieval$filterBonusesArray(json, "bonuses");
                if (removed > 0) {
                    LOGGER.debug("[Medieval] Filtered {} invalid bonuses from {}", (Object)removed, (Object)entry.getKey());
                }
                if (!json.has("bonuses") || !json.getAsJsonArray("bonuses").isEmpty()) continue;
                LOGGER.debug("[Medieval] Removing {} (no valid bonuses remaining)", (Object)entry.getKey());
                mapIterator.remove();
                continue;
            }
            if ("affixes".equals(this.path)) {
                removed = DynamicRegistryMixin.medieval$filterAffixCategories(json);
                if (removed > 0) {
                    LOGGER.debug("[Medieval] Filtered {} invalid categories from affix {}", (Object)removed, (Object)entry.getKey());
                }
                if (!json.has("categories") || !json.getAsJsonArray("categories").isEmpty()) continue;
                LOGGER.debug("[Medieval] Removing affix {} (no valid categories remaining)", (Object)entry.getKey());
                mapIterator.remove();
                continue;
            }
            if (!"affix_loot_entries".equals(this.path) || !DynamicRegistryMixin.medieval$hasDisabledLootCategory(json)) continue;
            LOGGER.debug("[Medieval] Removing affix_loot_entry {} (disabled category)", (Object)entry.getKey());
            mapIterator.remove();
        }
    }

    @Unique
    private static int medieval$filterBonusesArray(JsonObject json, String arrayKey) {
        if (!json.has(arrayKey)) {
            return 0;
        }
        JsonElement bonusesElement = json.get(arrayKey);
        if (!bonusesElement.isJsonArray()) {
            return 0;
        }
        JsonArray bonuses = bonusesElement.getAsJsonArray();
        Iterator iterator = bonuses.iterator();
        int removed = 0;
        while (iterator.hasNext()) {
            JsonObject bonus;
            JsonElement bonusElement = (JsonElement)iterator.next();
            if (!bonusElement.isJsonObject() || !DynamicRegistryMixin.medieval$shouldRemoveBonus(bonus = bonusElement.getAsJsonObject())) continue;
            iterator.remove();
            ++removed;
        }
        return removed;
    }

    @Unique
    private static int medieval$filterAffixCategories(JsonObject json) {
        if (!json.has("categories")) {
            return 0;
        }
        JsonElement categoriesElement = json.get("categories");
        if (!categoriesElement.isJsonArray()) {
            return 0;
        }
        JsonArray categories = categoriesElement.getAsJsonArray();
        Iterator iterator = categories.iterator();
        int removed = 0;
        while (iterator.hasNext()) {
            String category;
            JsonElement catElement = (JsonElement)iterator.next();
            if (!catElement.isJsonPrimitive() || !DynamicRegistryMixin.medieval$isDisabledCategory(category = catElement.getAsString())) continue;
            iterator.remove();
            ++removed;
        }
        return removed;
    }

    @Unique
    private static boolean medieval$shouldRemoveBonus(JsonObject bonus) {
        JsonElement types;
        JsonObject gemClassObj;
        if (!bonus.has("gem_class")) {
            return false;
        }
        JsonElement gemClass = bonus.get("gem_class");
        if (gemClass.isJsonPrimitive()) {
            String category = gemClass.getAsString();
            boolean shouldRemove = DynamicRegistryMixin.medieval$isDisabledCategory(category);
            if (shouldRemove) {
                LOGGER.debug("[Medieval] Removing bonus with gem_class: {}", (Object)category);
            }
            return shouldRemove;
        }
        if (gemClass.isJsonObject() && (gemClassObj = gemClass.getAsJsonObject()).has("types") && (types = gemClassObj.get("types")).isJsonArray()) {
            JsonArray typesArray = types.getAsJsonArray();
            Iterator typeIterator = typesArray.iterator();
            int removedTypes = 0;
            while (typeIterator.hasNext()) {
                JsonElement type = (JsonElement)typeIterator.next();
                if (!type.isJsonPrimitive() || !DynamicRegistryMixin.medieval$isDisabledCategory(type.getAsString())) continue;
                LOGGER.debug("[Medieval] Removing type {} from gem_class types array", (Object)type.getAsString());
                typeIterator.remove();
                ++removedTypes;
            }
            if (typesArray.isEmpty()) {
                LOGGER.debug("[Medieval] All types removed from bonus, removing entire bonus");
                return true;
            }
            if (removedTypes > 0) {
                LOGGER.debug("[Medieval] Filtered {} types, {} remaining", (Object)removedTypes, (Object)typesArray.size());
            }
        }
        return false;
    }

    @Unique
    private static boolean medieval$isDisabledCategory(String category) {
        if (DISABLED_CATEGORIES.contains(category)) {
            return true;
        }
        for (String disabled : DISABLED_CATEGORIES) {
            if (!disabled.endsWith(":" + category)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static boolean medieval$hasDisabledLootCategory(JsonObject json) {
        JsonElement categoriesElement;
        String[] categoryFields;
        for (String field : categoryFields = new String[]{"loot_category", "category", "type"}) {
            String value;
            JsonElement element;
            if (!json.has(field) || !(element = json.get(field)).isJsonPrimitive() || !DynamicRegistryMixin.medieval$isDisabledCategory(value = element.getAsString())) continue;
            return true;
        }
        if (json.has("categories") && (categoriesElement = json.get("categories")).isJsonArray()) {
            JsonArray categories = categoriesElement.getAsJsonArray();
            if (categories.isEmpty()) {
                return false;
            }
            boolean allDisabled = true;
            for (JsonElement cat : categories) {
                if (!cat.isJsonPrimitive() || DynamicRegistryMixin.medieval$isDisabledCategory(cat.getAsString())) continue;
                allDisabled = false;
                break;
            }
            return allDisabled;
        }
        return false;
    }
}

