/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4969;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TownPortalScrollItem
extends class_1792 {
    private static final class_6862<class_3195> VILLAGE_TAG = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"minecraft", (String)"village"));
    private static final int CHANNEL_TICKS = 80;
    private static final int COOLDOWN_TICKS = 12000;
    private static final Logger LOGGER = LogManager.getLogger();

    public TownPortalScrollItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @NotNull
    public class_1839 method_7853(@NotNull class_1799 pStack) {
        return class_1839.field_8953;
    }

    public int method_7881(@NotNull class_1799 p_41454_, @NotNull class_1309 p_344979_) {
        return 80;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, context, tooltip, flag);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.medieval.town_portal_scroll.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43470((String)"Cast Time: 4.0s").method_27692(class_124.field_1060));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        player.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
        if (livingEntity instanceof class_3222) {
            class_3222 player = (class_3222)livingEntity;
            if (!level.field_9236) {
                double remainingSeconds = (double)remainingUseDuration / 20.0;
                String formattedTime = String.format("%.1f", remainingSeconds);
                player.method_7353((class_2561)class_2561.method_43470((String)("Channeling: " + formattedTime + "s")), true);
            }
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 entity) {
        class_2338 nearestVillage;
        Optional<class_243> respawnLocation;
        if (!(entity instanceof class_3222)) {
            return stack;
        }
        class_3222 player = (class_3222)entity;
        class_3218 serverLevel = player.method_51469();
        boolean teleported = false;
        class_5250 resultMessage = null;
        class_2338 respawnPos = player.method_26280();
        class_3218 respawnLevel = player.field_13995.method_3847(player.method_26281());
        if (respawnLevel != null && respawnPos != null && (respawnLocation = this.findRespawnLocation(respawnLevel, respawnPos, player.method_30631(), player.method_26282())).isPresent()) {
            class_243 pos = respawnLocation.get();
            player.method_14251(respawnLevel, pos.field_1352, pos.field_1351, pos.field_1350, player.method_36454(), player.method_36455());
            teleported = true;
            resultMessage = class_2561.method_43471((String)"item.medieval.town_portal_scroll.teleport_bed").method_27692(class_124.field_1060);
        }
        if (!teleported && (nearestVillage = serverLevel.method_8487(VILLAGE_TAG, player.method_24515(), 64, false)) != null) {
            class_2338 safePos = this.findSafeSpawnLocation(serverLevel, nearestVillage);
            player.method_14251(serverLevel, (double)safePos.method_10263() + 0.5, (double)safePos.method_10264() + 0.1, (double)safePos.method_10260() + 0.5, player.method_36454(), player.method_36455());
            teleported = true;
            resultMessage = class_2561.method_43471((String)"item.medieval.town_portal_scroll.teleport_village").method_27692(class_124.field_1060);
        }
        if (!teleported) {
            class_3218 overworld = player.field_13995.method_30002();
            class_2338 worldSpawn = overworld.method_43126();
            player.method_14251(overworld, (double)worldSpawn.method_10263() + 0.5, (double)worldSpawn.method_10264() + 0.1, (double)worldSpawn.method_10260() + 0.5, player.method_36454(), player.method_36455());
            teleported = true;
            resultMessage = class_2561.method_43471((String)"item.medieval.town_portal_scroll.teleport_world_spawn").method_27692(class_124.field_1060);
        }
        if (teleported) {
            serverLevel.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 0.75f);
            player.method_7357().method_7906((class_1792)this, 12000);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
        }
        if (resultMessage != null) {
            player.method_7353(resultMessage, true);
        }
        return stack;
    }

    private Optional<class_243> findRespawnLocation(class_3218 level, class_2338 pos, float angle, boolean forced) {
        class_2680 blockState = level.method_8320(pos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_4969 && (forced || (Integer)blockState.method_11654((class_2769)class_4969.field_23153) > 0) && class_4969.method_27353((class_1937)level)) {
            return class_4969.method_26156((class_1299)class_1299.field_6097, (class_1941)level, (class_2338)pos);
        }
        if (block instanceof class_2244 && class_2244.method_27352((class_1937)level)) {
            return class_2244.method_9484((class_1299)class_1299.field_6097, (class_1941)level, (class_2338)pos, (class_2350)((class_2350)blockState.method_11654((class_2769)class_2244.field_11177)), (float)angle);
        }
        if (forced) {
            boolean flag = block.method_9538(blockState);
            class_2680 blockState1 = level.method_8320(pos.method_10084());
            boolean flag1 = blockState1.method_26204().method_9538(blockState1);
            if (flag && flag1) {
                return Optional.of(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5));
            }
        }
        return Optional.empty();
    }

    private boolean isSafeSpawn(class_3218 level, class_2338 pos) {
        if (!level.method_8320(pos).method_26215() || !level.method_8320(pos.method_10084()).method_26215()) {
            return false;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339(pos.method_10263(), pos.method_10264(), pos.method_10260());
        while (mutable.method_10264() < level.method_31600()) {
            class_2680 state = level.method_8320((class_2338)mutable);
            if (!state.method_26215() && !state.method_51176()) {
                return false;
            }
            mutable.method_10098(class_2350.field_11036);
        }
        return level.method_8320(pos.method_10074()).method_51367();
    }

    private class_2338 findSafeSpawnLocation(class_3218 level, class_2338 start) {
        class_2338.class_2339 mutable = new class_2338.class_2339(start.method_10263(), Math.min(level.method_31600(), start.method_10264() + 10), start.method_10260());
        while (mutable.method_10264() > level.method_31607()) {
            class_2338 below = mutable.method_10074();
            class_2680 belowState = level.method_8320(below);
            if (belowState.method_51367()) {
                if (!this.isSafeSpawn(level, (class_2338)mutable)) break;
                return mutable.method_10062();
            }
            mutable.method_10098(class_2350.field_11033);
        }
        mutable.method_10103(start.method_10263(), start.method_10264(), start.method_10260());
        while (mutable.method_10264() < level.method_31600() - 1) {
            if (this.isSafeSpawn(level, (class_2338)mutable)) {
                return mutable.method_10062();
            }
            mutable.method_10098(class_2350.field_11036);
        }
        return start;
    }
}

