/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.muon.medieval.quest.TaskTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class TemperatureTask
extends AbstractBooleanTask {
    private int targetTemperature = 0;
    private TemperatureComparison comparison = TemperatureComparison.ABOVE;

    public int autoSubmitOnPlayerTick() {
        return this.comparison == TemperatureComparison.EQUAL ? 1 : 20;
    }

    public TemperatureTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return TaskTypes.TEMPERATURE;
    }

    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10569("target_temperature", this.targetTemperature);
        nbt.method_10569("comparison", this.comparison.ordinal());
    }

    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.targetTemperature = nbt.method_10550("target_temperature");
        this.comparison = TemperatureComparison.values()[nbt.method_10550("comparison")];
    }

    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_53002(this.targetTemperature);
        buffer.method_10817((Enum)this.comparison);
    }

    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.targetTemperature = buffer.readInt();
        this.comparison = (TemperatureComparison)buffer.method_10818(TemperatureComparison.class);
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("target_temperature", this.targetTemperature, v -> {
            this.targetTemperature = v;
        }, 0, -14000, 14000);
        config.addEnum("comparison", (Object)this.comparison, v -> {
            this.comparison = v;
        }, TemperatureComparison.NAME_MAP);
    }

    public class_2561 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.task.medieval.temperature").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)String.format("%d", this.targetTemperature)).method_27692(class_124.field_1077)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("ftbquests.task.medieval.temperature." + this.comparison.name().toLowerCase())));
    }

    public boolean canSubmit(TeamData teamData, class_3222 player) {
        int playerTemperature = player.thermoo$getTemperature();
        return this.checkTemperature(playerTemperature);
    }

    public boolean checkTemperature(int playerTemperature) {
        return switch (this.comparison.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (playerTemperature > this.targetTemperature) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (playerTemperature < this.targetTemperature) {
                    yield true;
                }
                yield false;
            }
            case 2 -> playerTemperature == this.targetTemperature;
        };
    }

    public static enum TemperatureComparison {
        ABOVE,
        BELOW,
        EQUAL;

        public static final NameMap<TemperatureComparison> NAME_MAP;

        static {
            NAME_MAP = NameMap.of((Object)((Object)ABOVE), (Object[])TemperatureComparison.values()).create();
        }
    }
}

