/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.config;

import java.util.Arrays;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MedievalConfig {
    public static final ModConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        ModConfigSpec.Builder commonBuilder = new ModConfigSpec.Builder();
        COMMON = new Common(commonBuilder);
        COMMON_SPEC = commonBuilder.build();
        ModConfigSpec.Builder clientBuilder = new ModConfigSpec.Builder();
        CLIENT = new Client(clientBuilder);
        CLIENT_SPEC = clientBuilder.build();
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<List<? extends String>> structureNamespaces;
        public final ModConfigSpec.ConfigValue<List<? extends String>> additionalStructures;
        public final ModConfigSpec.ConfigValue<List<? extends String>> excludedStructurePaths;

        Common(ModConfigSpec.Builder builder) {
            builder.push("Structure Regeneration");
            this.structureNamespaces = builder.comment("List of namespaces to allow regeneration for. Structures from these namespaces can be regenerated.").defineListAllowEmpty("structure_namespaces", Arrays.asList("dungeons_arise", "dungeons_arise_seven_seas", "cataclysm", "bosses_of_mass_destruction", "formidulus", "irons_spellbooks", "illager_invasion", "adventuredungeons", "aether", "betterdungeons", "betterdeserttemples", "betterjungletemples", "betterfortresses", "betteroceanmonuments", "nova_structures"), () -> "", obj -> obj instanceof String);
            this.excludedStructurePaths = builder.comment(new String[]{"List of structure path sections to EXCLUDE regeneration for. If a structure ID's path (the part after the colon) contains any string in this list, it will be excluded, even if its namespace is allowed.", "Useful for excluding specific types like 'village' across allowed namespaces."}).defineListAllowEmpty("excluded_structure_patterns", Arrays.asList("village", "tavern", "inn", "well"), () -> "", obj -> obj instanceof String && !((String)obj).contains(":"));
            this.additionalStructures = builder.comment("List of specific structures (namespace:path) to allow regeneration for, IN ADDITION to the namespaces above. Bypasses the exclude patterns above.").defineListAllowEmpty("additional_structures", Arrays.asList("minecraft:ancient_city", "minecraft:end_city", "eternal_starlight:golem_forge", "eternal_starlight:cursed_garden", "deep_aether:brass_dungeon"), () -> "", obj -> obj instanceof String && ((String)obj).contains(":"));
            builder.pop();
        }
    }

    public static class Client {
        public final ModConfigSpec.DoubleValue combatMusicDetectionRadius;

        Client(ModConfigSpec.Builder builder) {
            builder.push("Reactive Music Integration");
            this.combatMusicDetectionRadius = builder.comment("The horizontal radius (in blocks) around the player to check for hostile mobs that can trigger combat music.").defineInRange("combat_music_detection_radius", 24.0, 1.0, 128.0);
            builder.pop();
        }
    }
}

