/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.world.structure;

import dev.muon.medieval.config.MedievalConfig;
import dev.muon.medieval.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1531;
import net.minecraft.class_1532;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1667;
import net.minecraft.class_1679;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2621;
import net.minecraft.class_2672;
import net.minecraft.class_2810;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_6025;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureRegenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int SEARCH_RADIUS = 6;

    public static RegenerationResult regenerateStructure(class_3218 level, class_2338 pos, class_2960 structureId) {
        if (!StructureRegenerator.isValidStructure(structureId)) {
            return new RegenerationResult(false, "Structure not allowed by config");
        }
        class_3449 structureStart = StructureRegenerator.findNearestStructure(level, pos, structureId);
        if (structureStart == null || !structureStart.method_16657()) {
            return new RegenerationResult(false, "Structure not found or invalid");
        }
        LOGGER.info("Found structure {} at {}", (Object)structureId, (Object)structureStart.method_14969().method_22874());
        class_2338 claimedChunkCenter = StructureRegenerator.isAnyClaimed(level, structureStart.method_14969());
        if (claimedChunkCenter != null) {
            String claimResult = String.format("Chunk at (%d, ~, %d) is claimed", claimedChunkCenter.method_10263(), claimedChunkCenter.method_10260());
            LOGGER.info("Structure {} contains claimed chunks. Regeneration cancelled. {}", (Object)structureId, (Object)claimResult);
            return new RegenerationResult(false, claimResult);
        }
        long startTime = System.currentTimeMillis();
        class_3341 boundingBox = structureStart.method_14969();
        class_1923 chunkPosMin = new class_1923(class_4076.method_18675((int)boundingBox.method_35415()), class_4076.method_18675((int)boundingBox.method_35417()));
        class_1923 chunkPosMax = new class_1923(class_4076.method_18675((int)boundingBox.method_35418()), class_4076.method_18675((int)boundingBox.method_35420()));
        StructureRegenerator.removeExistingEntities(level, boundingBox);
        StructureRegenerator.unpackAndDeleteLootContainers(level, boundingBox);
        ArrayList<class_1923> affectedChunks = new ArrayList<class_1923>();
        class_1923.method_19281((class_1923)chunkPosMin, (class_1923)chunkPosMax).forEach(chunkPos -> {
            structureStart.method_14974((class_5281)level, level.method_27056(), level.method_14178().method_12129(), level.method_8409(), new class_3341(chunkPos.method_8326(), level.method_31607(), chunkPos.method_8328(), chunkPos.method_8327(), level.method_31600(), chunkPos.method_8329()), chunkPos);
            level.method_8497(chunkPos.field_9181, chunkPos.field_9180).method_12008(true);
            affectedChunks.add((class_1923)chunkPos);
        });
        for (class_1923 chunkPos2 : affectedChunks) {
            level.method_14178().method_14128(new class_2338(chunkPos2.method_8326(), 0, chunkPos2.method_8328()));
        }
        StructureRegenerator.resendChunksAndUpdateLighting(level, affectedChunks);
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        LOGGER.info("Regenerated structure {} in {} ms", (Object)structureId, (Object)duration);
        level.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14956, class_3419.field_15248, 2.0f, 0.5f);
        return new RegenerationResult(true, duration + " ms");
    }

    private static void resendChunksAndUpdateLighting(class_3218 level, List<class_1923> chunks) {
        for (class_1923 chunkPos : chunks) {
            class_2818 chunk = level.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            class_2672 packet = new class_2672(chunk, level.method_22336(), null, null);
            for (class_3222 player : level.method_14178().field_17254.method_17210(chunkPos, false)) {
                player.field_13987.method_14364((class_2596)packet);
            }
        }
    }

    public static class_2338 isAnyClaimed(class_3218 level, class_3341 boundingBox) {
        if (Services.PLATFORM.isModLoaded("ftbchunks")) {
            return Services.PLATFORM.getFTBHelper().isAnyClaimed(level, boundingBox);
        }
        return null;
    }

    public static boolean isValidStructure(class_2960 structureId) {
        List allowedNamespaces = (List)MedievalConfig.COMMON.structureNamespaces.get();
        List allowedStructures = (List)MedievalConfig.COMMON.additionalStructures.get();
        List excludedPaths = (List)MedievalConfig.COMMON.excludedStructurePaths.get();
        if (allowedStructures != null && allowedStructures.contains(structureId.toString())) {
            return true;
        }
        if (excludedPaths != null) {
            String path = structureId.method_12832();
            for (String excludedPath : excludedPaths) {
                if (!path.equals(excludedPath)) continue;
                return false;
            }
        }
        return allowedNamespaces != null && allowedNamespaces.contains(structureId.method_12836());
    }

    private static void removeExistingEntities(class_3218 level, class_3341 boundingBox) {
        List entitiesToRemove = level.method_8390(class_1297.class, new class_238((double)boundingBox.method_35415(), (double)boundingBox.method_35416(), (double)boundingBox.method_35417(), (double)(boundingBox.method_35418() + 1), (double)(boundingBox.method_35419() + 1), (double)(boundingBox.method_35420() + 1)), StructureRegenerator::shouldRemoveEntity);
        entitiesToRemove.forEach(class_1297::method_31472);
    }

    private static boolean shouldRemoveEntity(class_1297 entity) {
        if (entity instanceof class_1308) {
            return !(entity instanceof class_6025) || ((class_6025)entity).method_35057() == null;
        }
        return entity instanceof class_1534 || entity instanceof class_1533 || entity instanceof class_1531 || entity instanceof class_1688 || entity instanceof class_1690 || entity instanceof class_1532 || entity instanceof class_1667 || entity instanceof class_1679;
    }

    private static void unpackAndDeleteLootContainers(class_3218 level, class_3341 boundingBox) {
        class_2338.method_10094((int)boundingBox.method_35415(), (int)boundingBox.method_35416(), (int)boundingBox.method_35417(), (int)boundingBox.method_35418(), (int)boundingBox.method_35419(), (int)boundingBox.method_35420()).forEach(pos -> {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof class_2621) {
                class_2621 container = (class_2621)blockEntity;
                container.method_54873(null);
                container.method_5448();
                container.method_5431();
                level.method_8650(pos, false);
            }
        });
    }

    public static class_3449 findNearestStructure(class_3218 level, class_2338 pos, class_2960 structureId) {
        HashMap<class_3195, class_3449> structures = new HashMap<class_3195, class_3449>();
        int searchRadius = 6;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                class_1923 chunkPos = new class_1923((pos.method_10263() >> 4) + x, (pos.method_10260() >> 4) + z);
                Map structuresInChunk = level.method_27056().method_41037(chunkPos.method_8323());
                for (Map.Entry entry : structuresInChunk.entrySet()) {
                    class_3449 start;
                    if (!level.method_30349().method_30530(class_7924.field_41246).method_10221((Object)((class_3195)entry.getKey())).equals((Object)structureId) || (start = level.method_27056().method_26975(class_4076.method_18681((class_1923)chunkPos, (int)0), (class_3195)entry.getKey(), (class_2810)level.method_8497(chunkPos.field_9181, chunkPos.field_9180))) == null || !start.method_16657()) continue;
                    structures.put((class_3195)entry.getKey(), start);
                }
            }
        }
        if (structures.isEmpty()) {
            return null;
        }
        return structures.values().stream().min((s1, s2) -> Double.compare(s1.method_14969().method_22874().method_10262((class_2382)pos), s2.method_14969().method_22874().method_10262((class_2382)pos))).orElse(null);
    }

    public static class RegenerationResult {
        public final boolean success;
        public final String message;

        public RegenerationResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }
    }
}

