/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPluginNeoForge
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"Medieval-Mixin");

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.contains(".compat.")) {
            String[] parts = mixinClassName.split("\\.");
            ArrayList<String> requiredMods = new ArrayList<String>();
            Set<String> excludedDirectories = Set.of("client", "accessor");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].equals("compat")) continue;
                for (int j = i + 1; j < parts.length - 1; ++j) {
                    String potentialModId = parts[j];
                    if (excludedDirectories.contains(potentialModId)) continue;
                    requiredMods.add(potentialModId);
                }
                break;
            }
            for (String modId : requiredMods) {
                if (MixinConfigPluginNeoForge.isModLoaded(modId)) continue;
                LOGGER.info("Disabling mixin {} because required mod '{}' is not loaded", (Object)this.getSimpleMixinName(mixinClassName), (Object)modId);
                return false;
            }
            if (!requiredMods.isEmpty()) {
                LOGGER.info("Enabling mixin {} - all required mods {} are loaded", (Object)this.getSimpleMixinName(mixinClassName), requiredMods);
            }
            return true;
        }
        return true;
    }

    private String getSimpleMixinName(String mixinClassName) {
        String[] parts = mixinClassName.split("\\.");
        return parts[parts.length - 1];
    }

    private static boolean isModLoaded(String modId) {
        if (ModList.get() == null) {
            return LoadingModList.get().getModFileById(modId) != null;
        }
        return ModList.get().isLoaded(modId);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

