/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.attribute;

import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;

public class AttributeRemapper {
    private static final Map<Holder<Attribute>, AttributeMapping> MAPPINGS = new HashMap<Holder<Attribute>, AttributeMapping>();

    private static boolean isModLoaded(String modId) {
        if (ModList.get() == null) {
            return LoadingModList.get().getMods().stream().map(ModInfo::getModId).anyMatch(modId::equals);
        }
        return ModList.get().isLoaded(modId);
    }

    private static void register(Holder<Attribute> source, Holder<Attribute> target, double conversionRate) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("Source or target Holder cannot be null during registration.");
        }
        MAPPINGS.put(source, new AttributeMapping(target, conversionRate));
    }

    public static Holder<Attribute> getRemappedHolder(Holder<Attribute> holder) {
        AttributeMapping mapping = MAPPINGS.get(holder);
        return mapping != null ? mapping.target() : holder;
    }

    public static double getConvertedValue(Holder<Attribute> source, double value) {
        AttributeMapping mapping = MAPPINGS.get(source);
        return mapping != null ? value * mapping.conversionRate() : value;
    }

    static {
        if (AttributeRemapper.isModLoaded("ars_nouveau") && AttributeRemapper.isModLoaded("irons_spellbooks")) {
            AttributeRemapper.register((Holder<Attribute>)AttributeRegistry.MAX_MANA, (Holder<Attribute>)PerkAttributes.MAX_MANA, 1.0);
            AttributeRemapper.register((Holder<Attribute>)AttributeRegistry.MANA_REGEN, (Holder<Attribute>)PerkAttributes.MANA_REGEN_BONUS, 1.0);
        }
    }

    private record AttributeMapping(Holder<Attribute> target, double conversionRate) {
    }
}

