/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.world.structure;

import dev.muon.medieval.config.MedievalConfig;
import dev.muon.medieval.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureRegenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int SEARCH_RADIUS = 6;

    public static RegenerationResult regenerateStructure(ServerLevel level, BlockPos pos, ResourceLocation structureId) {
        if (!StructureRegenerator.isValidStructure(structureId)) {
            return new RegenerationResult(false, "Structure not allowed by config");
        }
        StructureStart structureStart = StructureRegenerator.findNearestStructure(level, pos, structureId);
        if (structureStart == null || !structureStart.isValid()) {
            return new RegenerationResult(false, "Structure not found or invalid");
        }
        LOGGER.info("Found structure {} at {}", (Object)structureId, (Object)structureStart.getBoundingBox().getCenter());
        BlockPos claimedChunkCenter = StructureRegenerator.isAnyClaimed(level, structureStart.getBoundingBox());
        if (claimedChunkCenter != null) {
            String claimResult = String.format("Chunk at (%d, ~, %d) is claimed", claimedChunkCenter.getX(), claimedChunkCenter.getZ());
            LOGGER.info("Structure {} contains claimed chunks. Regeneration cancelled. {}", (Object)structureId, (Object)claimResult);
            return new RegenerationResult(false, claimResult);
        }
        long startTime = System.currentTimeMillis();
        BoundingBox boundingBox = structureStart.getBoundingBox();
        ChunkPos chunkPosMin = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.minX()), SectionPos.blockToSectionCoord((int)boundingBox.minZ()));
        ChunkPos chunkPosMax = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.maxX()), SectionPos.blockToSectionCoord((int)boundingBox.maxZ()));
        StructureRegenerator.removeExistingEntities(level, boundingBox);
        StructureRegenerator.unpackAndDeleteLootContainers(level, boundingBox);
        ArrayList<ChunkPos> affectedChunks = new ArrayList<ChunkPos>();
        ChunkPos.rangeClosed((ChunkPos)chunkPosMin, (ChunkPos)chunkPosMax).forEach(chunkPos -> {
            structureStart.placeInChunk((WorldGenLevel)level, level.structureManager(), level.getChunkSource().getGenerator(), level.getRandom(), new BoundingBox(chunkPos.getMinBlockX(), level.getMinBuildHeight(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), level.getMaxBuildHeight(), chunkPos.getMaxBlockZ()), chunkPos);
            level.getChunk(chunkPos.x, chunkPos.z).setUnsaved(true);
            affectedChunks.add((ChunkPos)chunkPos);
        });
        for (ChunkPos chunkPos2 : affectedChunks) {
            level.getChunkSource().blockChanged(new BlockPos(chunkPos2.getMinBlockX(), 0, chunkPos2.getMinBlockZ()));
        }
        StructureRegenerator.resendChunksAndUpdateLighting(level, affectedChunks);
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        LOGGER.info("Regenerated structure {} in {} ms", (Object)structureId, (Object)duration);
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.PLAYERS, 2.0f, 0.5f);
        return new RegenerationResult(true, duration + " ms");
    }

    private static void resendChunksAndUpdateLighting(ServerLevel level, List<ChunkPos> chunks) {
        for (ChunkPos chunkPos : chunks) {
            LevelChunk chunk = level.getChunk(chunkPos.x, chunkPos.z);
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(chunk, level.getLightEngine(), null, null);
            for (ServerPlayer player : level.getChunkSource().chunkMap.getPlayers(chunkPos, false)) {
                player.connection.send((Packet)packet);
            }
        }
    }

    public static BlockPos isAnyClaimed(ServerLevel level, BoundingBox boundingBox) {
        if (Services.PLATFORM.isModLoaded("ftbchunks")) {
            return Services.PLATFORM.getFTBHelper().isAnyClaimed(level, boundingBox);
        }
        return null;
    }

    public static boolean isValidStructure(ResourceLocation structureId) {
        List allowedNamespaces = (List)MedievalConfig.COMMON.structureNamespaces.get();
        List allowedStructures = (List)MedievalConfig.COMMON.additionalStructures.get();
        List excludedPaths = (List)MedievalConfig.COMMON.excludedStructurePaths.get();
        if (allowedStructures != null && allowedStructures.contains(structureId.toString())) {
            return true;
        }
        if (excludedPaths != null) {
            String path = structureId.getPath();
            for (String excludedPath : excludedPaths) {
                if (!path.equals(excludedPath)) continue;
                return false;
            }
        }
        return allowedNamespaces != null && allowedNamespaces.contains(structureId.getNamespace());
    }

    private static void removeExistingEntities(ServerLevel level, BoundingBox boundingBox) {
        List entitiesToRemove = level.getEntitiesOfClass(Entity.class, new AABB((double)boundingBox.minX(), (double)boundingBox.minY(), (double)boundingBox.minZ(), (double)(boundingBox.maxX() + 1), (double)(boundingBox.maxY() + 1), (double)(boundingBox.maxZ() + 1)), StructureRegenerator::shouldRemoveEntity);
        entitiesToRemove.forEach(Entity::discard);
    }

    private static boolean shouldRemoveEntity(Entity entity) {
        if (entity instanceof Mob) {
            if (entity instanceof OwnableEntity && ((OwnableEntity)entity).getOwner() instanceof Player) {
                return false;
            }
            if (entity.hasControllingPassenger() && entity.getControllingPassenger() instanceof Player) {
                return false;
            }
        }
        return entity instanceof Painting || entity instanceof ItemFrame || entity instanceof ArmorStand || entity instanceof AbstractMinecart || entity instanceof Boat || entity instanceof LeashFenceKnotEntity || entity instanceof Arrow || entity instanceof SpectralArrow;
    }

    private static void unpackAndDeleteLootContainers(ServerLevel level, BoundingBox boundingBox) {
        BlockPos.betweenClosed((int)boundingBox.minX(), (int)boundingBox.minY(), (int)boundingBox.minZ(), (int)boundingBox.maxX(), (int)boundingBox.maxY(), (int)boundingBox.maxZ()).forEach(pos -> {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
                container.unpackLootTable(null);
                container.clearContent();
                container.setChanged();
                level.removeBlock(pos, false);
            }
        });
    }

    public static StructureStart findNearestStructure(ServerLevel level, BlockPos pos, ResourceLocation structureId) {
        HashMap<Structure, StructureStart> structures = new HashMap<Structure, StructureStart>();
        int searchRadius = 6;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                ChunkPos chunkPos = new ChunkPos((pos.getX() >> 4) + x, (pos.getZ() >> 4) + z);
                Map structuresInChunk = level.structureManager().getAllStructuresAt(chunkPos.getWorldPosition());
                for (Map.Entry entry : structuresInChunk.entrySet()) {
                    StructureStart start;
                    if (!level.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)((Structure)entry.getKey())).equals((Object)structureId) || (start = level.structureManager().getStartForStructure(SectionPos.of((ChunkPos)chunkPos, (int)0), (Structure)entry.getKey(), (StructureAccess)level.getChunk(chunkPos.x, chunkPos.z))) == null || !start.isValid()) continue;
                    structures.put((Structure)entry.getKey(), start);
                }
            }
        }
        if (structures.isEmpty()) {
            return null;
        }
        return structures.values().stream().min((s1, s2) -> Double.compare(s1.getBoundingBox().getCenter().distSqr((Vec3i)pos), s2.getBoundingBox().getCenter().distSqr((Vec3i)pos))).orElse(null);
    }

    public static class RegenerationResult {
        public final boolean success;
        public final String message;

        public RegenerationResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }
    }
}

