/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.muon.medieval.Medieval;
import dev.muon.medieval.compat.OverflowingBarsCompat;
import dev.muon.medieval.config.MedievalConfig;
import dev.muon.medieval.item.ItemRegistry;
import dev.muon.medieval.item.ItemRegistryFabric;
import dev.muon.medieval.platform.MedievalPlatformHelperFabric;
import dev.muon.medieval.platform.Services;
import dev.muon.medieval.quest.TaskTypes;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeConfigRegistry;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderGuiLayerEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;

public class MedievalFabric
implements ModInitializer {
    private static final List<String> TARGET_NAMESPACES = Arrays.asList("dungeons_arise", "aether", "adventuredungeons", "dungeons_arise_seven_seas", "mes", "nova_structures", "the_bumblezone", "ati_structures");
    private static final List<class_6862<class_3195>> DIFFICULTY_TAGS = Arrays.asList(class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"dungeon_difficulty", (String)"level_1")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"dungeon_difficulty", (String)"level_2")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"dungeon_difficulty", (String)"level_3")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"dungeon_difficulty", (String)"level_4")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"dungeon_difficulty", (String)"level_5")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60655((String)"dungeon_difficulty", (String)"level_6")));

    public void onInitialize() {
        Medieval.LOG.info("Hello Fabric world!");
        Medieval.init();
        Medieval.setHelper(new MedievalPlatformHelperFabric());
        Services.setup(new MedievalPlatformHelperFabric());
        TaskTypes.init();
        ItemRegistryFabric.init();
        this.registerCreativeTabs();
        NeoForgeConfigRegistry.INSTANCE.register("medieval", ModConfig.Type.COMMON, (IConfigSpec)MedievalConfig.COMMON_SPEC);
        NeoForgeConfigRegistry.INSTANCE.register("medieval", ModConfig.Type.CLIENT, (IConfigSpec)MedievalConfig.CLIENT_SPEC);
        this.initializeCompat();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> MedievalFabric.registerCommand((CommandDispatcher<class_2168>)dispatcher));
    }

    public void initializeCompat() {
        if (FabricLoader.getInstance().isModLoaded("overflowingbars")) {
            RenderGuiLayerEvents.before((class_2960)RenderGuiLayerEvents.PLAYER_HEALTH).register(OverflowingBarsCompat::onRenderPlayerHealth);
        }
    }

    private void registerCreativeTabs() {
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)Medieval.loc("medieval_tab"), (Object)FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)ItemRegistry.CHALLENGE_ORB)).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.medieval")).method_47317((parameters, output) -> {
            output.method_45421((class_1935)ItemRegistry.CHALLENGE_ORB);
            output.method_45421((class_1935)ItemRegistry.TOWN_PORTAL_SCROLL);
        }).method_47324());
    }

    private static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dumpstructures").requires(source -> source.method_9259(2))).executes(MedievalFabric::runDumpCommand));
    }

    private static int runDumpCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        source.method_45068((class_2561)class_2561.method_43470((String)"Starting structure ID dump... Check server logs."));
        Medieval.LOG.info("Structure dump initiated by command from: " + source.method_9214());
        try {
            class_2378 structureRegistry = server.method_30611().method_30530(class_7924.field_41246);
            Set allStructureIdsInTargetNamespaces = structureRegistry.method_10235().stream().filter(id -> TARGET_NAMESPACES.contains(id.method_12836())).collect(Collectors.toSet());
            HashSet categorizedStructureIds = new HashSet();
            Medieval.LOG.info("--- Dumping Structure IDs by Difficulty Tag ---");
            for (class_6862<class_3195> tagKey : DIFFICULTY_TAGS) {
                Medieval.LOG.info("--- Structures in Tag: " + String.valueOf(tagKey.comp_327()) + " ---");
                ArrayList structuresInThisTag = new ArrayList();
                structureRegistry.method_40286(tagKey).forEach(holder -> {
                    class_2960 id = ((class_5321)holder.method_40230().get()).method_29177();
                    if (allStructureIdsInTargetNamespaces.contains(id)) {
                        structuresInThisTag.add(id);
                    }
                });
                structuresInThisTag.stream().sorted(class_2960::method_12833).forEach(id -> {
                    Medieval.LOG.info(id.toString());
                    categorizedStructureIds.add(id);
                });
                if (!structuresInThisTag.isEmpty()) continue;
                Medieval.LOG.info("No structures found in this tag and target namespaces.");
            }
            Medieval.LOG.info("--- Uncategorized Structures (from target namespaces) ---");
            List<class_2960> uncategorizedStructures = allStructureIdsInTargetNamespaces.stream().filter(id -> !categorizedStructureIds.contains(id)).sorted(class_2960::method_12833).collect(Collectors.toList());
            if (uncategorizedStructures.isEmpty()) {
                Medieval.LOG.info("No uncategorized structures found in target namespaces.");
            } else {
                uncategorizedStructures.forEach(id -> Medieval.LOG.info(id.toString()));
            }
            Medieval.LOG.info("--- Structure ID Dump Complete ---");
            source.method_45068((class_2561)class_2561.method_43470((String)"Structure dump complete."));
        }
        catch (Exception e) {
            Medieval.LOG.error("Error occurred during structure dump command:", (Throwable)e);
            source.method_9213((class_2561)class_2561.method_43470((String)"Error during structure dump. See logs."));
        }
        return 1;
    }
}

