/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.medieval.Medieval;
import dev.muon.medieval.hotbar.HUDPositioning;
import dev.muon.medieval.hotbar.Position;
import dev.muon.medieval.hotbar.RenderUtil;
import java.lang.reflect.Method;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class HealthBarRenderer {
    private static float lastHealth = -1.0f;
    private static long fullHealthStartTime = 0L;

    public static void render(class_332 graphics, class_1657 player, float maxHealth, float actualHealth, int absorptionAmount, class_9779 deltaTracker) {
        if (!class_310.method_1551().field_1761.method_2908()) {
            return;
        }
        Position healthPos = HUDPositioning.getHealthAnchor().offset(HUDPositioning.getHealthBarXOffset(), HUDPositioning.getHealthBarYOffset());
        int borderWidth = 80;
        int borderHeight = 10;
        int barWidth = 74;
        int barHeight = 4;
        int barXOffset = 3;
        int barYOffset = 3;
        int animationCycles = 33;
        int frameHeight = 6;
        int xPos = healthPos.x();
        int yPos = healthPos.y();
        graphics.method_25290(Medieval.loc("textures/gui/health_border.png"), xPos, yPos, 0.0f, 0.0f, borderWidth, borderHeight, 256, 256);
        int animOffset = (int)(((float)player.field_6012 + deltaTracker.method_60636()) / 3.0f % (float)animationCycles) * frameHeight;
        HealthBarRenderer.renderBaseBar(graphics, player, maxHealth, actualHealth, xPos, yPos, barWidth, barHeight, barXOffset, barYOffset, animOffset);
        HealthBarRenderer.renderBarOverlays(graphics, player, absorptionAmount, xPos, yPos, barWidth, barHeight, barXOffset, barYOffset);
        HealthBarRenderer.renderBorderOverlays(graphics, player, xPos, yPos, borderWidth, borderHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textX = xPos + borderWidth / 2;
        int textY = yPos + barYOffset;
        if (HealthBarRenderer.shouldRenderText(actualHealth, maxHealth)) {
            int color = HealthBarRenderer.getHealthTextColor();
            RenderUtil.renderText(actualHealth, maxHealth, graphics, textX, textY, color);
        }
        if (absorptionAmount > 0) {
            String absorptionText = "+" + absorptionAmount;
            int absorptionX = xPos + borderWidth - barXOffset - class_310.method_1551().field_1772.method_1727(absorptionText) / 2;
            RenderUtil.renderAdditionText(absorptionText, graphics, absorptionX, textY, -922746881);
        }
    }

    private static void renderBaseBar(class_332 graphics, class_1657 player, float maxHealth, float actualHealth, int xPos, int yPos, int barWidth, int barHeight, int barXOffset, int barYOffset, int animOffset) {
        BarType barType = BarType.fromPlayerState(player);
        int partialBarWidth = (int)((float)barWidth * (actualHealth / maxHealth));
        graphics.method_25290(Medieval.loc("textures/gui/" + barType.getTexture() + ".png"), xPos + barXOffset, yPos + barYOffset, 0.0f, (float)animOffset, partialBarWidth, barHeight, 256, 256);
    }

    private static void renderBarOverlays(class_332 graphics, class_1657 player, int absorptionAmount, int xPos, int yPos, int barWidth, int barHeight, int barXOffset, int barYOffset) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float tempScale = HealthBarRenderer.getTemperatureScale(player);
        HealthBarRenderer.renderTemperatureOverlay(graphics, tempScale, xPos, yPos, barWidth, barHeight, barXOffset, barYOffset);
        if (absorptionAmount > 0) {
            graphics.method_25290(Medieval.loc("textures/gui/absorption_overlay.png"), xPos + barXOffset, yPos + barYOffset, 0.0f, 0.0f, barWidth, barHeight, 256, 256);
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderBorderOverlays(class_332 graphics, class_1657 player, int xPos, int yPos, int borderWidth, int borderHeight) {
        float wetScale;
        if (player.method_37908().method_8401().method_152()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            graphics.method_25290(Medieval.loc("textures/gui/hardcore_overlay.png"), xPos, yPos, 0.0f, 0.0f, borderWidth, borderHeight, 256, 256);
            RenderSystem.disableBlend();
        }
        if ((wetScale = HealthBarRenderer.getWetnessScale(player)) > 0.0f) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)wetScale);
            graphics.method_25290(Medieval.loc("textures/gui/wetness_overlay.png"), xPos, yPos, 0.0f, 0.0f, borderWidth, borderHeight, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    private static void renderTemperatureOverlay(class_332 graphics, float tempScale, int xPos, int yPos, int barWidth, int barHeight, int barXOffset, int barYOffset) {
        if (tempScale > 0.0f) {
            int heatWidth = (int)((float)barWidth * tempScale);
            graphics.method_25290(Medieval.loc("textures/gui/heat_overlay.png"), xPos + barXOffset, yPos + barYOffset, 0.0f, 0.0f, heatWidth, barHeight, 256, 256);
        } else if (tempScale < 0.0f) {
            int coldWidth = (int)((float)barWidth * -tempScale);
            graphics.method_25290(Medieval.loc("textures/gui/cold_overlay.png"), xPos + barXOffset, yPos + barYOffset, 0.0f, 0.0f, coldWidth, barHeight, 256, 256);
        }
    }

    private static float getWetnessScale(class_1657 player) {
        try {
            Method getWetScale = player.getClass().getMethod("thermoo$getSoakedScale", new Class[0]);
            return ((Float)getWetScale.invoke((Object)player, new Object[0])).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static boolean isScorched(class_1657 player) {
        try {
            Method getMaxTemp = player.getClass().getMethod("thermoo$getMaxTemperature", new Class[0]);
            Method getTemp = player.getClass().getMethod("thermoo$getTemperature", new Class[0]);
            int maxTemperature = (Integer)getMaxTemp.invoke((Object)player, new Object[0]);
            int temperature = (Integer)getTemp.invoke((Object)player, new Object[0]);
            return (double)temperature > 0.5 && temperature >= maxTemperature - 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isFrozen(class_1657 player) {
        if (player.method_32314()) {
            return true;
        }
        try {
            Method getTemp = player.getClass().getMethod("thermoo$getTemperature", new Class[0]);
            Method getTempScale = player.getClass().getMethod("thermoo$getTemperatureScale", new Class[0]);
            int minTemperature = (Integer)getTemp.invoke((Object)player, new Object[0]);
            if (minTemperature < 0) {
                float tempScale = ((Float)getTempScale.invoke((Object)player, new Object[0])).floatValue();
                return tempScale <= -0.99f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static float getTemperatureScale(class_1657 player) {
        try {
            Method getTempScale = player.getClass().getMethod("thermoo$getTemperatureScale", new Class[0]);
            return ((Float)getTempScale.invoke((Object)player, new Object[0])).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static int getHealthTextColor() {
        long timeSinceFullHealth = fullHealthStartTime > 0L ? System.currentTimeMillis() - fullHealthStartTime : 0L;
        int alpha = RenderUtil.calculateTextAlpha(timeSinceFullHealth, 2000L, 500L, 200);
        alpha = Math.max(10, alpha);
        return alpha << 24 | 0xFFFFFF;
    }

    private static boolean shouldRenderText(float currentHealth, float maxHealth) {
        if (currentHealth >= maxHealth) {
            if (lastHealth < maxHealth) {
                fullHealthStartTime = System.currentTimeMillis();
            }
        } else {
            fullHealthStartTime = 0L;
        }
        lastHealth = currentHealth;
        long timeSinceFullHealth = fullHealthStartTime > 0L ? System.currentTimeMillis() - fullHealthStartTime : 0L;
        return currentHealth < maxHealth || fullHealthStartTime > 0L && timeSinceFullHealth < 2000L;
    }

    private static enum BarType {
        NORMAL("health_bar"),
        POISON("health_bar_poison"),
        WITHER("health_bar_wither"),
        FROZEN("health_bar_frozen"),
        SCORCHED("health_bar_scorched");

        private final String texture;

        private BarType(String texture) {
            this.texture = texture;
        }

        public String getTexture() {
            return this.texture;
        }

        public static BarType fromPlayerState(class_1657 player) {
            if (player.method_6059(class_1294.field_5899)) {
                return POISON;
            }
            if (player.method_6059(class_1294.field_5920)) {
                return WITHER;
            }
            if (HealthBarRenderer.isFrozen(player)) {
                return FROZEN;
            }
            if (HealthBarRenderer.isScorched(player)) {
                return SCORCHED;
            }
            return NORMAL;
        }
    }
}

