/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.medieval.Medieval;
import dev.muon.medieval.hotbar.HUDPositioning;
import dev.muon.medieval.hotbar.Position;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class StaminaBarRenderer {
    private static final float SPRINT_THRESHOLD = 6.0f;

    public static void render(class_332 graphics, class_1657 player, class_9779 deltaTracker) {
        Position staminaPos = HUDPositioning.getHungerAnchor().offset(HUDPositioning.getStaminaBarXOffset(), HUDPositioning.getStaminaBarYOffset());
        int borderWidth = 80;
        int borderHeight = 10;
        int barWidth = 74;
        int barHeight = 4;
        int barXOffset = 3;
        int barYOffset = 3;
        int animationCycles = 33;
        int frameHeight = 6;
        int xPos = staminaPos.x() - borderWidth;
        int yPos = staminaPos.y();
        graphics.method_25290(Medieval.loc("textures/gui/stamina_border.png"), xPos, yPos, 0.0f, 0.0f, borderWidth, borderHeight, 256, 256);
        float maxStamina = 20.0f;
        float currentStamina = player.method_7344().method_7586();
        int animOffset = (int)(((float)player.field_6012 + deltaTracker.method_60636()) / 3.0f % (float)animationCycles) * frameHeight;
        StaminaBarRenderer.renderBaseBar(graphics, player, currentStamina, maxStamina, xPos, yPos, barWidth, barHeight, barXOffset, barYOffset, animOffset);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderBaseBar(class_332 graphics, class_1657 player, float currentStamina, float maxStamina, int xPos, int yPos, int barWidth, int barHeight, int barXOffset, int barYOffset, int animOffset) {
        BarType barType = BarType.fromPlayerState(player, currentStamina);
        int partialBarWidth = (int)((float)barWidth * (currentStamina / maxStamina));
        graphics.method_25290(Medieval.loc("textures/gui/" + barType.getTexture() + ".png"), xPos + barXOffset, yPos + barYOffset, 0.0f, (float)animOffset, partialBarWidth, barHeight, 256, 256);
    }

    private static enum BarType {
        NORMAL("stamina_bar"),
        HUNGER("stamina_bar_hunger"),
        CRITICAL("stamina_bar_critical");

        private final String texture;

        private BarType(String texture) {
            this.texture = texture;
        }

        public String getTexture() {
            return this.texture;
        }

        public static BarType fromPlayerState(class_1657 player, float stamina) {
            if (stamina <= 6.0f) {
                return CRITICAL;
            }
            if (player.method_6059(class_1294.field_5903)) {
                return HUNGER;
            }
            return NORMAL;
        }
    }
}

