/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.medieval.Medieval;
import dev.muon.medieval.StructureRegenerator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public abstract class ChallengeOrbItem
extends class_1792 {
    private static final int SEARCH_COOLDOWN = 25;
    private static final int COOLDOWN_TICKS = 600;
    private static final int SEARCH_TIMEOUT_TICKS = 100;

    public ChallengeOrbItem(class_1792.class_1793 properties) {
        super(properties);
    }

    protected abstract ChallengeOrbData getData(class_1799 var1);

    protected abstract void setData(class_1799 var1, ChallengeOrbData var2);

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, context, tooltip, flag);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.medieval.challenge_orb.tooltip").method_27692(class_124.field_1080));
    }

    public class_1271<class_1799> method_7836(class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        Medieval.LOG.info("ChallengeOrbItem used by player: {}", (Object)player.method_5477().getString());
        if (level.field_9236) {
            return class_1271.method_22427((Object)player.method_5998(hand));
        }
        class_3218 serverLevel = (class_3218)level;
        class_1799 itemStack = player.method_5998(hand);
        ChallengeOrbData data = this.getData(itemStack);
        if (data == null || data.foundStructure().isEmpty()) {
            this.findStructure(serverLevel, player, itemStack);
            player.method_7357().method_7906((class_1792)this, 25);
            return class_1271.method_22427((Object)itemStack);
        }
        long currentTime = serverLevel.method_8510();
        if (currentTime - data.searchTime() > 100L) {
            this.setData(itemStack, new ChallengeOrbData("", 0L));
            this.findStructure(serverLevel, player, itemStack);
            return class_1271.method_22427((Object)itemStack);
        }
        this.confirmAndRegenerate(serverLevel, player, itemStack);
        return class_1271.method_22427((Object)itemStack);
    }

    private void findStructure(class_3218 level, class_1657 player, class_1799 itemStack) {
        class_2378 structureRegistry = level.method_30349().method_30530(class_7924.field_41246);
        player.method_7353((class_2561)class_2561.method_43470((String)"Searching for nearby structure...").method_27692(class_124.field_1054), true);
        for (class_3195 structure : structureRegistry) {
            class_2960 structureId = structureRegistry.method_10221((Object)structure);
            if (structureId != null && StructureRegenerator.isValidStructure(structureId)) {
                class_3449 nearestStructure = StructureRegenerator.findNearestStructure(level, player.method_24515(), structureId);
                if (nearestStructure != null) {
                    this.setData(itemStack, new ChallengeOrbData(structureId.toString(), level.method_8510()));
                    player.method_7353((class_2561)class_2561.method_43470((String)("Found structure: " + String.valueOf(structureId) + ". Click again to regenerate.")).method_27692(class_124.field_1060), true);
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_23116, class_3419.field_15248, 1.0f, 2.0f);
                    return;
                }
                Medieval.LOG.debug("No instance of structure {} found nearby", (Object)structureId);
                continue;
            }
            Medieval.LOG.debug("Structure type {} is not valid for regeneration", (Object)structureId);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"No regeneratable structure found nearby.").method_27692(class_124.field_1061), true);
    }

    private void confirmAndRegenerate(class_3218 level, class_1657 player, class_1799 itemStack) {
        ChallengeOrbData data = this.getData(itemStack);
        if (data != null && data.foundStructure() != null) {
            try {
                class_2960 structureId = class_2960.method_60654((String)data.foundStructure());
                player.method_7353((class_2561)class_2561.method_43470((String)("Regenerating structure: " + String.valueOf(structureId))).method_27692(class_124.field_1054), true);
                StructureRegenerator.RegenerationResult result = StructureRegenerator.regenerateStructure(level, player.method_24515(), structureId);
                if (result.success) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Success! " + result.message)).method_27692(class_124.field_1060), true);
                    player.method_7357().method_7906((class_1792)this, 600);
                    this.setData(itemStack, new ChallengeOrbData("", 0L));
                    if (!player.method_31549().field_7477) {
                        itemStack.method_7934(1);
                    }
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Failed: " + result.message)).method_27692(class_124.field_1061), true);
                }
            }
            catch (class_151 e) {
                Medieval.LOG.error("Invalid structure ID: {}", (Object)data.foundStructure(), (Object)e);
                player.method_7353((class_2561)class_2561.method_43470((String)"Error: Invalid structure ID").method_27692(class_124.field_1061), true);
            }
        }
    }

    public record ChallengeOrbData(String foundStructure, long searchTime) {
        public static final Codec<ChallengeOrbData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("foundStructure", (Object)"").forGetter(ChallengeOrbData::foundStructure), (App)Codec.LONG.fieldOf("searchTime").forGetter(ChallengeOrbData::searchTime)).apply((Applicative)instance, ChallengeOrbData::new));
    }
}

