/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval;

import dev.muon.medieval.compat.travelersbackpack.TravelersBackpackCompat;
import dev.muon.medieval.config.MedievalConfig;
import dev.muon.medieval.item.ItemRegistry;
import dev.muon.medieval.leveling.EnhancedEntityLevelingSettingsReloader;
import dev.muon.medieval.leveling.LevelSyncHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="medieval")
public class Medieval {
    public static final String MODID = "medieval";
    public static final Logger LOGGER = LogManager.getLogger();

    public Medieval(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::interMod);
        LOGGER.info("Medieval MC Forge Tweaks loading");
        MedievalConfig.register();
        ItemRegistry.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(Medieval.class);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LevelSyncHandler.init(event);
    }

    private void interMod(InterModEnqueueEvent event) {
        event.enqueueWork(() -> {
            if (ModList.get().isLoaded("travelersbackpack")) {
                TravelersBackpackCompat.init();
            }
        });
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        if (ModList.get().isLoaded("autoleveling")) {
            event.addListener((PreparableReloadListener)new EnhancedEntityLevelingSettingsReloader());
        }
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MODID, path);
    }
}

