/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.medieval.Medieval;
import dev.muon.medieval.hotbar.HUDPositioning;
import dev.muon.medieval.hotbar.ManaProvider;
import dev.muon.medieval.hotbar.Position;
import dev.muon.medieval.hotbar.RenderUtil;
import net.minecraft.client.gui.GuiGraphics;

public class ManaBarRenderer {
    private static float lastMana = -1.0f;
    private static long fullManaStartTime = 0L;
    private static long barEnabledStartTime = 0L;
    private static long barDisabledStartTime = 0L;
    private static boolean barSetVisible = false;
    private static final int RESERVED_MANA_COLOR = 0x232323;

    public static void render(GuiGraphics graphics, float partialTicks, ManaProvider manaProvider) {
        float alpha = ManaBarRenderer.getCurrentAlpha();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Position manaPos = HUDPositioning.getAboveUtilitiesAnchor().offset(HUDPositioning.getManaBarXOffset(), HUDPositioning.getManaBarYOffset());
        int borderWidth = 80;
        int borderHeight = 10;
        int barWidth = 74;
        int barHeight = 4;
        int barXOffset = 3;
        int barYOffset = 3;
        int animationCycles = 33;
        int frameHeight = 6;
        int xPos = manaPos.x() - borderWidth / 2;
        int yPos = manaPos.y();
        ManaBarRenderer.renderMainBar(graphics, manaProvider, partialTicks, xPos, yPos, borderWidth, borderHeight, barWidth, barHeight, barXOffset, barYOffset, animationCycles, frameHeight);
        ManaBarRenderer.renderReservedOverlay(graphics, manaProvider, partialTicks, xPos, yPos, barWidth, barHeight, barXOffset, barYOffset, animationCycles, frameHeight);
        graphics.m_280163_(Medieval.loc("textures/gui/detail_overlay.png"), xPos + 0, yPos + -3, 0.0f, 0.0f, borderWidth, borderHeight, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textX = xPos + borderWidth / 2;
        int textY = yPos + barYOffset;
        if (ManaBarRenderer.shouldRenderText(manaProvider.getCurrentMana(), manaProvider.getMaxMana())) {
            int color = ManaBarRenderer.getManaTextColor();
            RenderUtil.renderText((float)manaProvider.getCurrentMana(), manaProvider.getMaxMana(), graphics, textX, textY, color);
        }
    }

    private static int getManaTextColor() {
        long timeSinceFullMana = fullManaStartTime > 0L ? System.currentTimeMillis() - fullManaStartTime : 0L;
        int alpha = RenderUtil.calculateTextAlpha(timeSinceFullMana, 2000L, 500L, 200);
        if (!barSetVisible) {
            float barAlpha = ManaBarRenderer.getCurrentAlpha();
            alpha = (int)((float)alpha * barAlpha);
        }
        alpha = Math.max(10, alpha);
        return alpha << 24 | 0xFFFFFF;
    }

    private static boolean shouldRenderText(double currentMana, float maxMana) {
        if (currentMana >= (double)maxMana) {
            if (lastMana < maxMana) {
                fullManaStartTime = System.currentTimeMillis();
            }
        } else {
            fullManaStartTime = 0L;
        }
        lastMana = (float)currentMana;
        long timeSinceFullMana = fullManaStartTime > 0L ? System.currentTimeMillis() - fullManaStartTime : 0L;
        return (currentMana < (double)maxMana || fullManaStartTime > 0L && timeSinceFullMana < 2000L) && ManaBarRenderer.getCurrentAlpha() > 0.05f;
    }

    private static float getCurrentAlpha() {
        if (barSetVisible) {
            return 1.0f;
        }
        long timeSinceHide = System.currentTimeMillis() - barDisabledStartTime;
        return Math.max(0.0f, 1.0f - (float)timeSinceHide / 1500.0f);
    }

    public static void setBarVisibility(boolean visible) {
        if (barSetVisible != visible) {
            if (visible) {
                barEnabledStartTime = System.currentTimeMillis();
            } else {
                barDisabledStartTime = System.currentTimeMillis();
            }
            barSetVisible = visible;
        }
    }

    private static void renderMainBar(GuiGraphics graphics, ManaProvider manaProvider, float partialTicks, int xPos, int yPos, int borderWidth, int borderHeight, int barWidth, int barHeight, int barXOffset, int barYOffset, int animationCycles, int frameHeight) {
        graphics.m_280163_(Medieval.loc("textures/gui/mana_border.png"), xPos, yPos, 0.0f, 0.0f, borderWidth, borderHeight, 256, 256);
        float maxMana = manaProvider.getMaxMana() * (1.0f + manaProvider.getReservedMana());
        double currentMana = manaProvider.getCurrentMana();
        int partialBarWidth = (int)((double)barWidth * (currentMana / (double)maxMana));
        int manaOffset = (int)(((float)manaProvider.getGameTime() + partialTicks) / 3.0f % (float)animationCycles) * frameHeight;
        graphics.m_280163_(Medieval.loc("textures/gui/mana_bar.png"), xPos + barXOffset, yPos + barYOffset, 0.0f, (float)manaOffset, partialBarWidth, barHeight, 256, 256);
    }

    private static void renderReservedOverlay(GuiGraphics graphics, ManaProvider manaProvider, float partialTicks, int xPos, int yPos, int barWidth, int barHeight, int barXOffset, int barYOffset, int animationCycles, int frameHeight) {
        float reservedMana = manaProvider.getReservedMana();
        if (reservedMana <= 0.0f) {
            return;
        }
        int reserveManaLength = (int)((float)barWidth * reservedMana);
        int offset = barWidth - reserveManaLength;
        int manaOffset = (int)(((float)manaProvider.getGameTime() + partialTicks) / 3.0f % (float)animationCycles) * frameHeight;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.13725491f, (float)0.13725491f, (float)0.13725491f, (float)1.0f);
        graphics.m_280163_(Medieval.loc("textures/gui/mana_bar.png"), xPos + barXOffset + offset, yPos + barYOffset, 0.0f, (float)manaOffset, reserveManaLength, barHeight, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static boolean isVisible() {
        return barSetVisible || System.currentTimeMillis() - barDisabledStartTime <= 1500L;
    }
}

