/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.item;

import dev.muon.medieval.world.structure.StructureRegenerator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public class ChallengeOrbItem
extends Item {
    private static final int SEARCH_COOLDOWN = 25;
    private static final int COOLDOWN_TICKS = 600;
    private static final int SEARCH_TIMEOUT_TICKS = 100;

    public ChallengeOrbItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item.medieval.challenge_orb.tooltip").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        long searchTime;
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack itemStack = player.m_21120_(hand);
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("FoundStructure")) {
            this.findStructure(serverLevel, player, itemStack);
            player.m_36335_().m_41524_((Item)this, 25);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        long currentTime = serverLevel.m_46467_();
        if (currentTime - (searchTime = tag.m_128454_("SearchTime")) > 100L) {
            tag.m_128473_("FoundStructure");
            tag.m_128473_("SearchTime");
            this.findStructure(serverLevel, player, itemStack);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        this.confirmAndRegenerate(serverLevel, player, itemStack);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    private void findStructure(ServerLevel level, Player player, ItemStack itemStack) {
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        for (Structure structure : structureRegistry) {
            ResourceLocation structureId = structureRegistry.m_7981_((Object)structure);
            if (!StructureRegenerator.isValidStructure(structureId)) continue;
            player.m_5661_((Component)Component.m_237115_((String)"item.medieval.challenge_orb.searching").m_130940_(ChatFormatting.YELLOW), true);
            if (StructureRegenerator.findNearestStructure(level, player.m_20183_(), structureId) == null) continue;
            CompoundTag tag = itemStack.m_41784_();
            tag.m_128359_("FoundStructure", structureId.toString());
            tag.m_128356_("SearchTime", level.m_46467_());
            player.m_5661_((Component)Component.m_237110_((String)"item.medieval.challenge_orb.found", (Object[])new Object[]{structureId}).m_130940_(ChatFormatting.GREEN), true);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12376_, SoundSource.PLAYERS, 1.0f, 2.0f);
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)"item.medieval.challenge_orb.not_found").m_130940_(ChatFormatting.RED), true);
    }

    private void confirmAndRegenerate(ServerLevel level, Player player, ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_("FoundStructure")) {
            ResourceLocation structureId = new ResourceLocation(tag.m_128461_("FoundStructure"));
            player.m_5661_((Component)Component.m_237110_((String)"item.medieval.challenge_orb.regenerating", (Object[])new Object[]{structureId}).m_130940_(ChatFormatting.YELLOW), true);
            StructureRegenerator.RegenerationResult result = StructureRegenerator.regenerateStructure(level, player.m_20183_(), structureId);
            if (result.success) {
                player.m_5661_((Component)Component.m_237110_((String)"item.medieval.challenge_orb.success", (Object[])new Object[]{result.message}).m_130940_(ChatFormatting.GREEN), true);
                player.m_36335_().m_41524_((Item)this, 600);
                itemStack.m_41774_(1);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"item.medieval.challenge_orb.fail", (Object[])new Object[]{result.message}).m_130940_(ChatFormatting.RED), true);
            }
            tag.m_128473_("FoundStructure");
        }
    }
}

