/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.item;

import dev.muon.medieval.config.MedievalConfig;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LootLimiter {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        Collection drops = event.getDrops();
        int totalStacks = 0;
        for (ItemEntity item : drops) {
            ++totalStacks;
        }
        if (totalStacks > MedievalConfig.get().maxStacksPerEntity) {
            ArrayList<ItemEntity> limitedDrops = new ArrayList<ItemEntity>();
            int currentStacks = 0;
            for (ItemEntity item : new ArrayList(drops)) {
                if (currentStacks >= MedievalConfig.get().maxStacksPerEntity) continue;
                limitedDrops.add(item);
                ++currentStacks;
            }
            drops.clear();
            drops.addAll(limitedDrops);
        }
    }
}

