/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.leveling;

import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import daripher.autoleveling.event.MobsLevelingEvents;
import daripher.skilltree.capability.skill.IPlayerSkills;
import daripher.skilltree.capability.skill.PlayerSkillsProvider;
import dev.muon.medieval.config.MedievalConfig;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;

public class LevelingUtils {
    private static final int MAX_LEVEL = 20;
    private static final int START_LEVEL = 2;
    private static final int MIN_POINTS = 8;
    private static final int MAX_POINTS = 80;
    private static final int POINTS_PER_LEVEL = 4;

    public static int getPlayerLevel(Player player) {
        AptitudeCapability aptitude;
        int level = 2;
        if (ModList.get().isLoaded("skilltree") && PlayerSkillsProvider.hasSkills((Player)player)) {
            IPlayerSkills skills = PlayerSkillsProvider.get((Player)player);
            level = Math.max(2, 2 + skills.getPlayerSkills().size() - 1);
        } else if (ModList.get().isLoaded("justlevelingfork") && (aptitude = AptitudeCapability.get((Player)player)) != null) {
            int totalPoints = aptitude.getGlobalLevel();
            level = Math.min(20, 2 + (totalPoints - 8) / 4);
        }
        return level;
    }

    public static double getPlayerLevelProgress(Player player) {
        AptitudeCapability aptitude;
        if (ModList.get().isLoaded("justlevelingfork") && (aptitude = AptitudeCapability.get((Player)player)) != null) {
            int totalPoints = aptitude.getGlobalLevel();
            if (totalPoints >= 80) {
                return 100.0;
            }
            return (double)((totalPoints - 8) % 4) / 4.0 * 100.0;
        }
        return 0.0;
    }

    public static int getEntityLevel(LivingEntity entity) {
        if (ModList.get().isLoaded("autoleveling")) {
            return MobsLevelingEvents.getLevel((LivingEntity)entity) + 1;
        }
        return 0;
    }

    public static int getLevelsOfNearbyPlayers(ServerLevel level, LivingEntity entity) {
        List nearbyPlayers = level.m_45976_(Player.class, entity.m_20191_().m_82400_(MedievalConfig.get().levelingSearchRadius));
        if (nearbyPlayers.isEmpty()) {
            return 0;
        }
        int levelsToAdd = 0;
        if (ModList.get().isLoaded("skilltree")) {
            levelsToAdd += LevelingUtils.calculateSkillTreeLevels(nearbyPlayers);
        }
        return levelsToAdd;
    }

    private static int calculateSkillTreeLevels(List<Player> players) {
        int totalSkillPoints = players.stream().filter(PlayerSkillsProvider::hasSkills).mapToInt(player -> PlayerSkillsProvider.get((Player)player).getPlayerSkills().size()).sum();
        int averageSkillPoints = totalSkillPoints / players.size();
        return (int)((double)averageSkillPoints * MedievalConfig.get().levelsPerPoint);
    }
}

