/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals;

import com.shweit.etherealportals.command.EpDebugCommand;
import com.shweit.etherealportals.command.PortalCommand;
import com.shweit.etherealportals.listener.InventoryClickListener;
import com.shweit.etherealportals.listener.InventoryCloseListener;
import com.shweit.etherealportals.listener.PlayerMoveListener;
import com.shweit.etherealportals.manager.CooldownManager;
import com.shweit.etherealportals.manager.DataManager;
import com.shweit.etherealportals.manager.IconManager;
import com.shweit.etherealportals.manager.PortalManager;
import com.shweit.etherealportals.util.MessageUtils;
import com.shweit.etherealportals.visual.VisualEffectTask;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EtherealPortals
extends JavaPlugin {
    private PortalManager portalManager;
    private IconManager iconManager;
    private DataManager dataManager;
    private CooldownManager cooldownManager;
    private VisualEffectTask visualTask;
    private double hitboxWidth;
    private double hitboxDepth;
    private double hitboxHeight;

    public PortalManager getPortalManager() {
        return this.portalManager;
    }

    public IconManager getIconManager() {
        return this.iconManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public VisualEffectTask getVisualTask() {
        return this.visualTask;
    }

    public double getHitboxWidth() {
        return this.hitboxWidth;
    }

    public double getHitboxDepth() {
        return this.hitboxDepth;
    }

    public double getHitboxHeight() {
        return this.hitboxHeight;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadLocalConfig();
        this.portalManager = new PortalManager();
        this.iconManager = new IconManager();
        this.cooldownManager = new CooldownManager(this.getConfig().getInt("portal.teleport.cooldownSeconds", 3), this.getConfig().getInt("portal.teleport.messageCooldownSeconds", 1));
        this.dataManager = new DataManager(this, this.portalManager, this.iconManager);
        this.registerCommands();
        this.registerListeners();
        this.visualTask = new VisualEffectTask(this);
        this.visualTask.start();
        MessageUtils.send((CommandSender)this.getServer().getConsoleSender(), "Plugin enabled.");
    }

    public void onDisable() {
        this.dataManager.saveGroups();
        this.dataManager.saveIcons();
        if (this.visualTask != null) {
            this.visualTask.stop();
        }
    }

    public void reloadLocalConfig() {
        this.reloadConfig();
        this.hitboxWidth = this.getConfig().getDouble("portal.hitbox.width", 2.0);
        this.hitboxDepth = this.getConfig().getDouble("portal.hitbox.depth", 2.0);
        this.hitboxHeight = this.getConfig().getDouble("portal.hitbox.height", 2.0);
        if (this.cooldownManager != null) {
            this.cooldownManager.updateConfig(this.getConfig().getInt("portal.teleport.cooldownSeconds", 3), this.getConfig().getInt("portal.teleport.messageCooldownSeconds", 1));
        }
    }

    private void registerCommands() {
        PluginCommand debugCmd;
        PluginCommand portalCmd = this.getCommand("portal");
        if (portalCmd != null) {
            PortalCommand executor = new PortalCommand(this);
            portalCmd.setExecutor((CommandExecutor)executor);
            portalCmd.setTabCompleter((TabCompleter)executor);
        }
        if ((debugCmd = this.getCommand("epdebug")) != null) {
            EpDebugCommand debugExecutor = new EpDebugCommand(this);
            debugCmd.setExecutor((CommandExecutor)debugExecutor);
            debugCmd.setTabCompleter((TabCompleter)debugExecutor);
        }
    }

    private void registerListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        pm.registerEvents((Listener)new InventoryClickListener(this), (Plugin)this);
        pm.registerEvents((Listener)new InventoryCloseListener(), (Plugin)this);
    }
}

