/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.command;

import com.shweit.etherealportals.EtherealPortals;
import com.shweit.etherealportals.manager.IconManager;
import com.shweit.etherealportals.manager.PortalManager;
import com.shweit.etherealportals.model.Portal;
import com.shweit.etherealportals.model.PortalGroup;
import com.shweit.etherealportals.model.PortalIcon;
import com.shweit.etherealportals.util.MessageUtils;
import com.shweit.etherealportals.util.SkullUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PortalCommand
implements CommandExecutor,
TabCompleter {
    private final EtherealPortals plugin;

    public PortalCommand(EtherealPortals plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            MessageUtils.info(sender, "Usage: &d/portal &7<&bgroup&7|&bicon&7> &7<subcommand>");
            return true;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "group": {
                this.handleGroup(sender, args);
                return true;
            }
            case "icon": {
                this.handleIcon(sender, args);
                return true;
            }
        }
        MessageUtils.error(sender, "Unknown category! Use &d/portal group &cor &d/portal icon&c.");
        return true;
    }

    private void handleGroup(CommandSender sender, String[] args) {
        String sub;
        PortalManager pm = this.plugin.getPortalManager();
        if (args.length < 2) {
            MessageUtils.info(sender, "Available commands: &dcreate&7, &ddelete&7, &dadd&7, &dremove&7, &dlist");
            return;
        }
        switch (sub = args[1].toLowerCase()) {
            case "create": {
                if (!sender.hasPermission("portal.group.create")) {
                    this.noPerm(sender);
                    return;
                }
                if (args.length < 3) {
                    MessageUtils.info(sender, "Usage: &d/portal group create &b<name>");
                    return;
                }
                pm.createGroupIfAbsent(args[2]);
                MessageUtils.success(sender, "Portal group &d" + args[2] + "&a has been created!");
                this.plugin.getDataManager().saveGroups();
                return;
            }
            case "delete": {
                if (!sender.hasPermission("portal.group.delete")) {
                    this.noPerm(sender);
                    return;
                }
                if (args.length < 3) {
                    MessageUtils.info(sender, "Usage: &d/portal group delete &b<name>");
                    return;
                }
                PortalGroup group = pm.getGroup(args[2]);
                boolean ok = pm.deleteGroup(args[2]);
                if (ok) {
                    if (group != null) {
                        this.plugin.getVisualTask().removeGroupTextDisplays(group);
                    }
                    MessageUtils.success(sender, "Portal group &d" + args[2] + "&a has been deleted.");
                } else {
                    MessageUtils.error(sender, "Portal group &d" + args[2] + "&c doesn't exist.");
                }
                this.plugin.getDataManager().saveGroups();
                return;
            }
            case "add": {
                World w;
                if (!sender.hasPermission("portal.group.add")) {
                    this.noPerm(sender);
                    return;
                }
                if (!(sender instanceof Player)) {
                    MessageUtils.error(sender, "This command can only be used by players.");
                    return;
                }
                if (args.length < 7) {
                    MessageUtils.info(sender, "Usage: &d/portal group add &b<group> <name> <x> <y> <z> &7[world] [icon]");
                    return;
                }
                Player p = (Player)sender;
                String group = args[2];
                String name = args[3];
                double x = MessageUtils.parseRelative(p, args[4], p.getLocation().getX());
                double y = MessageUtils.parseRelative(p, args[5], p.getLocation().getY());
                double z = MessageUtils.parseRelative(p, args[6], p.getLocation().getZ());
                World world = p.getWorld();
                if (args.length >= 8 && (w = Bukkit.getWorld((String)args[7])) != null) {
                    world = w;
                }
                String icon = args.length >= 9 ? args[8] : null;
                Location portalLoc = new Location(world, Math.floor(x), Math.floor(y), Math.floor(z));
                boolean added = pm.addPortal(group, name, portalLoc, icon);
                if (added) {
                    MessageUtils.success(sender, "Portal &d" + name + "&a has been added to group &d" + group + "&a!");
                    this.plugin.getVisualTask().createTextDisplay(portalLoc.clone().add(0.5, 3.0, 0.5), group, name);
                } else {
                    MessageUtils.error(sender, "A portal with the name &d" + name + "&c already exists in this group.");
                }
                this.plugin.getDataManager().saveGroups();
                return;
            }
            case "remove": {
                if (!sender.hasPermission("portal.group.remove")) {
                    this.noPerm(sender);
                    return;
                }
                if (args.length < 4) {
                    MessageUtils.info(sender, "Usage: &d/portal group remove &b<group> <name>");
                    return;
                }
                String groupName = args[2];
                String portalName = args[3];
                boolean removed = pm.removePortal(groupName, portalName);
                if (removed) {
                    this.plugin.getVisualTask().removeTextDisplay(groupName, portalName);
                    MessageUtils.success(sender, "Portal &d" + portalName + "&a has been removed from group &d" + groupName + "&a.");
                } else {
                    MessageUtils.error(sender, "Portal &d" + portalName + "&c doesn't exist in group &d" + groupName + "&c.");
                }
                this.plugin.getDataManager().saveGroups();
                return;
            }
            case "list": {
                if (!sender.hasPermission("portal.use")) {
                    this.noPerm(sender);
                    return;
                }
                if (args.length == 2) {
                    if (pm.getGroups().isEmpty()) {
                        MessageUtils.warning(sender, "No portal groups have been created yet.");
                    } else {
                        MessageUtils.info(sender, "Portal Groups &7(" + pm.getGroups().size() + ")&7: &d" + pm.getGroups().stream().map(PortalGroup::getName).collect(Collectors.joining("&7, &d")));
                    }
                } else {
                    PortalGroup g = pm.getGroup(args[2]);
                    if (g == null) {
                        MessageUtils.error(sender, "Portal group &d" + args[2] + "&c doesn't exist.");
                        return;
                    }
                    if (g.getPortals().isEmpty()) {
                        MessageUtils.warning(sender, "Group &d" + g.getName() + "&e doesn't have any portals yet.");
                    } else {
                        MessageUtils.info(sender, "Portals in &d" + g.getName() + " &7(" + g.getPortals().size() + ")&7: &d" + g.getPortals().stream().map(Portal::getName).collect(Collectors.joining("&7, &d")));
                    }
                }
                return;
            }
        }
        MessageUtils.error(sender, "Unknown subcommand! Use &d/portal group &cto see available commands.");
    }

    private void handleIcon(CommandSender sender, String[] args) {
        String sub;
        IconManager im = this.plugin.getIconManager();
        if (args.length < 2) {
            MessageUtils.info(sender, "Available commands: &dadd&7, &dremove&7, &dlist");
            return;
        }
        switch (sub = args[1].toLowerCase()) {
            case "add": {
                if (!sender.hasPermission("portal.icon.add")) {
                    this.noPerm(sender);
                    return;
                }
                if (args.length < 4) {
                    MessageUtils.info(sender, "Usage: &d/portal icon add &b<name> <base64>");
                    return;
                }
                boolean ok = im.addIcon(args[2], args[3]);
                if (ok) {
                    MessageUtils.success(sender, "Custom icon &d" + args[2] + "&a has been added!");
                } else {
                    MessageUtils.error(sender, "An icon with the name &d" + args[2] + "&c already exists.");
                }
                this.plugin.getDataManager().saveIcons();
                return;
            }
            case "remove": {
                if (!sender.hasPermission("portal.icon.remove")) {
                    this.noPerm(sender);
                    return;
                }
                if (args.length < 3) {
                    MessageUtils.info(sender, "Usage: &d/portal icon remove &b<name>");
                    return;
                }
                boolean ok = im.removeIcon(args[2]);
                if (ok) {
                    MessageUtils.success(sender, "Custom icon &d" + args[2] + "&a has been removed.");
                } else {
                    MessageUtils.error(sender, "Icon &d" + args[2] + "&c doesn't exist.");
                }
                this.plugin.getDataManager().saveIcons();
                return;
            }
            case "list": {
                if (!(sender instanceof Player)) {
                    MessageUtils.error(sender, "This command can only be used by players.");
                    return;
                }
                if (!sender.hasPermission("portal.icon.list")) {
                    this.noPerm(sender);
                    return;
                }
                Player p = (Player)sender;
                this.openIconList(p);
                return;
            }
        }
        MessageUtils.error(sender, "Unknown subcommand! Use &d/portal icon &cto see available commands.");
    }

    private void openIconList(Player player) {
        int size = 9 * (this.plugin.getIconManager().getIcons().size() / 9 + 1);
        if (size > 54) {
            size = 54;
        }
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)size, (String)(String.valueOf(ChatColor.DARK_PURPLE) + "Icons"));
        for (PortalGroup portalGroup : this.plugin.getPortalManager().getGroups()) {
        }
        this.plugin.getIconManager().getIcons().forEach(icon -> {
            ItemStack head = SkullUtils.createHead(icon.getBase64(), String.valueOf(ChatColor.LIGHT_PURPLE) + icon.getName());
            ItemMeta meta = head.getItemMeta();
            if (meta != null) {
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Custom Icon")));
                meta.setLore(lore);
                if (!head.setItemMeta(meta)) {
                    this.plugin.getLogger().warning("Failed to set item meta for icon: " + icon.getName());
                }
            }
            inv.addItem(new ItemStack[]{head});
        });
        player.openInventory(inv);
    }

    private void noPerm(CommandSender sender) {
        MessageUtils.error(sender, "You don't have permission to use this command.");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subCmd;
        if (args.length == 1) {
            return this.partial(args[0], List.of("group", "icon"));
        }
        if (args[0].equalsIgnoreCase("group")) {
            if (args.length == 2) {
                return this.partial(args[1], List.of("create", "delete", "add", "remove", "list"));
            }
            subCmd = args[1].toLowerCase();
            PortalManager pm = this.plugin.getPortalManager();
            if (subCmd.equals("delete") && args.length == 3) {
                return this.partial(args[2], this.getGroupNames());
            }
            if (subCmd.equals("add")) {
                if (args.length == 3) {
                    return this.partial(args[2], this.getGroupNames());
                }
                if (args.length == 4) {
                    return Collections.singletonList("<portal_name>");
                }
                if (args.length >= 5 && args.length <= 7 && sender instanceof Player) {
                    Player p = (Player)sender;
                    Location loc = p.getLocation();
                    int index = args.length - 5;
                    String coord = index == 0 ? String.valueOf((int)loc.getX()) : (index == 1 ? String.valueOf((int)loc.getY()) : String.valueOf((int)loc.getZ()));
                    return this.partial(args[args.length - 1], List.of(coord, "~"));
                }
                if (args.length == 8) {
                    return this.partial(args[7], this.getWorldNames());
                }
                if (args.length == 9) {
                    return this.partial(args[8], this.getIconNames());
                }
            }
            if (subCmd.equals("remove")) {
                PortalGroup group;
                if (args.length == 3) {
                    return this.partial(args[2], this.getGroupNames());
                }
                if (args.length == 4 && (group = pm.getGroup(args[2])) != null) {
                    return this.partial(args[3], group.getPortals().stream().map(Portal::getName).collect(Collectors.toList()));
                }
            }
            if (subCmd.equals("list") && args.length == 3) {
                return this.partial(args[2], this.getGroupNames());
            }
        }
        if (args[0].equalsIgnoreCase("icon")) {
            if (args.length == 2) {
                return this.partial(args[1], List.of("add", "remove", "list"));
            }
            subCmd = args[1].toLowerCase();
            if (subCmd.equals("remove") && args.length == 3) {
                return this.partial(args[2], this.getIconNames());
            }
            if (subCmd.equals("add")) {
                if (args.length == 3) {
                    return Collections.singletonList("<icon_name>");
                }
                if (args.length == 4) {
                    return Collections.singletonList("<base64_texture>");
                }
            }
        }
        return Collections.emptyList();
    }

    private List<String> partial(String token, List<String> base) {
        String lower = token.toLowerCase();
        return base.stream().filter(s -> s.toLowerCase().startsWith(lower)).collect(Collectors.toList());
    }

    private List<String> getGroupNames() {
        return this.plugin.getPortalManager().getGroups().stream().map(PortalGroup::getName).collect(Collectors.toList());
    }

    private List<String> getIconNames() {
        return this.plugin.getIconManager().getIcons().stream().map(PortalIcon::getName).collect(Collectors.toList());
    }

    private List<String> getWorldNames() {
        return Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
    }
}

