/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.listener;

import com.shweit.etherealportals.EtherealPortals;
import com.shweit.etherealportals.manager.CooldownManager;
import com.shweit.etherealportals.manager.IconManager;
import com.shweit.etherealportals.manager.PortalManager;
import com.shweit.etherealportals.model.Portal;
import com.shweit.etherealportals.model.PortalGroup;
import com.shweit.etherealportals.model.PortalIcon;
import com.shweit.etherealportals.util.MessageUtils;
import com.shweit.etherealportals.util.SkullUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PlayerMoveListener
implements Listener {
    private final EtherealPortals plugin;
    private final Set<UUID> insidePortal = new HashSet<UUID>();

    public PlayerMoveListener(EtherealPortals plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        PortalManager pm = this.plugin.getPortalManager();
        PortalManager.PortalResult result = pm.findPortalAt(event.getTo(), this.plugin.getHitboxWidth(), this.plugin.getHitboxDepth(), this.plugin.getHitboxHeight());
        UUID uuid = player.getUniqueId();
        if (result != null) {
            if (!this.insidePortal.contains(uuid)) {
                this.insidePortal.add(uuid);
                this.handlePortalEnter(player, result.getPortal(), result.getGroup());
            }
        } else {
            this.insidePortal.remove(uuid);
        }
    }

    private void handlePortalEnter(Player player, Portal source, PortalGroup group) {
        if (group == null) {
            return;
        }
        int count = group.getPortals().size();
        if (count == 2) {
            Portal target = group.getPortals().stream().filter(p -> !p.getName().equals(source.getName())).findFirst().orElse(null);
            if (target != null) {
                this.teleport(player, target);
            }
        } else if (count >= 3) {
            this.openSelectionInventory(player, group, source);
        }
    }

    private void openSelectionInventory(Player player, PortalGroup group, Portal source) {
        int options = group.getPortals().size() - 1;
        int rows = Math.min(6, Math.max(1, (int)Math.ceil((double)options / 9.0)));
        int size = rows * 9;
        String title = String.valueOf(ChatColor.DARK_PURPLE) + "Select Portal";
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)size, (String)title);
        IconManager im = this.plugin.getIconManager();
        group.getPortals().stream().filter(p -> !p.getName().equals(source.getName())).forEach(portal -> {
            PortalIcon icon;
            String iconName = portal.getIconName();
            ItemStack item = iconName != null ? ((icon = im.getIcon(iconName)) != null ? SkullUtils.createHead(icon.getBase64(), String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + portal.getName()) : SkullUtils.createDefaultIcon(String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + portal.getName())) : SkullUtils.createDefaultIcon(String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + portal.getName());
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                if (!meta.hasDisplayName()) {
                    meta.setDisplayName(String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + portal.getName());
                }
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.GRAY) + MessageUtils.formatCoords(portal.getBaseLocation()));
                lore.add(String.valueOf(ChatColor.GRAY) + portal.getBaseLocation().getWorld().getName());
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.GREEN) + "Click to teleport!");
                meta.setLore(lore);
                if (!item.setItemMeta(meta)) {
                    this.plugin.getLogger().warning("Failed to set item meta for portal: " + portal.getName());
                }
            }
            inv.addItem(new ItemStack[]{item});
        });
        player.openInventory(inv);
    }

    private void teleport(Player player, Portal target) {
        CooldownManager cm = this.plugin.getCooldownManager();
        if (!cm.canTeleport(player.getUniqueId())) {
            if (cm.canMessage(player.getUniqueId())) {
                MessageUtils.cooldown((CommandSender)player, cm.remainingTeleport(player.getUniqueId()));
                cm.triggerMessage(player.getUniqueId());
            }
            return;
        }
        player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation(), 40, 0.5, 0.5, 0.5, 0.2);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        Location targetLoc = target.getCenterLocation();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> player.teleportAsync(targetLoc).thenRun(() -> {
            targetLoc.getWorld().spawnParticle(Particle.PORTAL, targetLoc, 50, 0.5, 0.5, 0.5, 0.25);
            targetLoc.getWorld().playSound(targetLoc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            MessageUtils.teleport((CommandSender)player, target.getName());
            cm.triggerTeleport(player.getUniqueId());
        }), 10L);
    }
}

