/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.model;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;

public class Portal {
    private final String name;
    private final Location baseLocation;
    private String iconName;

    public Portal(String name, Location baseLocation, String iconName) {
        this.name = name;
        this.baseLocation = baseLocation.clone();
        this.iconName = iconName;
    }

    public String getName() {
        return this.name;
    }

    public Location getBaseLocation() {
        return this.baseLocation.clone();
    }

    public Location getCenterLocation() {
        return this.baseLocation.clone().add(0.5, 0.0, 0.5);
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public void serialize(ConfigurationSection section) {
        section.set("world", (Object)this.baseLocation.getWorld().getName());
        section.set("x", (Object)this.baseLocation.getX());
        section.set("y", (Object)this.baseLocation.getY());
        section.set("z", (Object)this.baseLocation.getZ());
        section.set("yaw", (Object)Float.valueOf(this.baseLocation.getYaw()));
        section.set("pitch", (Object)Float.valueOf(this.baseLocation.getPitch()));
        if (this.iconName != null) {
            section.set("icon", (Object)this.iconName);
        }
    }

    public static Portal deserialize(String name, ConfigurationSection section, World world) {
        double x = section.getDouble("x");
        double y = section.getDouble("y");
        double z = section.getDouble("z");
        float yaw = (float)section.getDouble("yaw", 0.0);
        float pitch = (float)section.getDouble("pitch", 0.0);
        Location loc = new Location(world, x, y, z, yaw, pitch);
        String icon = section.getString("icon");
        return new Portal(name, loc, icon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Portal)) {
            return false;
        }
        Portal portal = (Portal)o;
        return this.name.equalsIgnoreCase(portal.name);
    }

    public int hashCode() {
        return Objects.hash(this.name.toLowerCase());
    }
}

