/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.model;

import com.shweit.etherealportals.model.Portal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PortalGroup {
    private final String name;
    private final Map<String, Portal> portals = new LinkedHashMap<String, Portal>();

    public PortalGroup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Portal> getPortals() {
        return Collections.unmodifiableCollection(this.portals.values());
    }

    public Portal getPortal(String portalName) {
        return this.portals.get(portalName.toLowerCase());
    }

    public boolean addPortal(Portal portal) {
        String key = portal.getName().toLowerCase();
        if (this.portals.containsKey(key)) {
            return false;
        }
        this.portals.put(key, portal);
        return true;
    }

    public boolean removePortal(String portalName) {
        return this.portals.remove(portalName.toLowerCase()) != null;
    }

    public boolean isEmpty() {
        return this.portals.isEmpty();
    }
}

