/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.visual;

import com.shweit.etherealportals.EtherealPortals;
import com.shweit.etherealportals.model.Portal;
import com.shweit.etherealportals.model.PortalGroup;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;

public class VisualEffectTask
implements Runnable {
    private final EtherealPortals plugin;
    private volatile int taskId = -1;

    public VisualEffectTask(EtherealPortals plugin) {
        this.plugin = plugin;
    }

    public void start() {
        if (this.taskId != -1) {
            return;
        }
        this.syncMissingTextDisplays();
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 40L, 20L);
    }

    public void stop() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
            this.taskId = -1;
        }
    }

    @Override
    public void run() {
        double t = (double)(System.currentTimeMillis() % 5000L) / 5000.0;
        this.plugin.getPortalManager().getGroups().forEach(group -> group.getPortals().forEach(portal -> {
            Location center = portal.getCenterLocation().clone().add(0.0, 0.1, 0.0);
            this.spawnSpiral(center, t);
        }));
    }

    private void spawnSpiral(Location center, double progress) {
        for (int i = 0; i < 24; ++i) {
            double angle = progress * 2.0 * Math.PI + (double)i * Math.PI / 6.0;
            double radius = 0.7;
            double y = (double)i / 24.0 * 2.5;
            double x = center.getX() + Math.cos(angle) * radius;
            double z = center.getZ() + Math.sin(angle) * radius;
            center.getWorld().spawnParticle(Particle.END_ROD, x, center.getY() + y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void removeTextDisplay(String groupName, String portalName) {
        String tag = "ep_portal:" + groupName.toLowerCase() + ":" + portalName.toLowerCase();
        Bukkit.getWorlds().forEach(world -> world.getEntitiesByClass(TextDisplay.class).stream().filter(td -> td.getScoreboardTags().contains(tag)).forEach(Entity::remove));
    }

    public void removeGroupTextDisplays(PortalGroup group) {
        group.getPortals().forEach(portal -> this.removeTextDisplay(group.getName(), portal.getName()));
    }

    public void createTextDisplay(Location loc, String groupName, String portalName) {
        String tag = "ep_portal:" + groupName.toLowerCase() + ":" + portalName.toLowerCase();
        loc.getWorld().spawn(loc, TextDisplay.class, d -> {
            d.text((Component)Component.text((String)(String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + portalName)));
            d.setBillboard(Display.Billboard.CENTER);
            d.setSeeThrough(true);
            d.setShadowed(true);
            d.setViewRange(50.0f);
            d.addScoreboardTag(tag);
        });
    }

    private void syncMissingTextDisplays() {
        int created = 0;
        for (PortalGroup group : this.plugin.getPortalManager().getGroups()) {
            for (Portal portal : group.getPortals()) {
                boolean exists;
                Location loc = portal.getBaseLocation().clone().add(0.5, 3.0, 0.5);
                String tag = "ep_portal:" + group.getName().toLowerCase() + ":" + portal.getName().toLowerCase();
                if (!loc.isChunkLoaded()) {
                    loc.getChunk().load();
                }
                if (exists = loc.getWorld().getEntitiesByClass(TextDisplay.class).stream().anyMatch(td -> td.getScoreboardTags().contains(tag))) continue;
                this.createTextDisplay(loc, group.getName(), portal.getName());
                ++created;
            }
        }
        if (created > 0) {
            this.plugin.getLogger().info("Created " + created + " missing portal TextDisplay(s)");
        }
    }
}

