/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.listener;

import com.shweit.etherealportals.EtherealPortals;
import com.shweit.etherealportals.manager.CooldownManager;
import com.shweit.etherealportals.manager.PortalManager;
import com.shweit.etherealportals.model.Portal;
import com.shweit.etherealportals.model.PortalGroup;
import com.shweit.etherealportals.util.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InventoryClickListener
implements Listener {
    private final EtherealPortals plugin;

    public InventoryClickListener(EtherealPortals plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        if (title.contains("Icons")) {
            event.setCancelled(true);
        } else if (title.contains("Select Portal")) {
            event.setCancelled(true);
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            ItemStack current = event.getCurrentItem();
            if (current == null || !current.hasItemMeta()) {
                return;
            }
            String displayName = current.getItemMeta().getDisplayName();
            String display = ChatColor.stripColor((String)displayName);
            if (display == null || display.isEmpty()) {
                return;
            }
            this.teleportByName(player, display.toLowerCase());
        }
    }

    private void teleportByName(Player player, String portalName) {
        PortalManager pm = this.plugin.getPortalManager();
        Portal target = null;
        for (PortalGroup group : pm.getGroups()) {
            Portal p = group.getPortal(portalName);
            if (p == null) continue;
            target = p;
            break;
        }
        if (target == null) {
            MessageUtils.error((CommandSender)player, "Could not find portal &d" + portalName + "&c.");
            return;
        }
        CooldownManager cm = this.plugin.getCooldownManager();
        if (!cm.canTeleport(player.getUniqueId())) {
            if (cm.canMessage(player.getUniqueId())) {
                MessageUtils.cooldown((CommandSender)player, cm.remainingTeleport(player.getUniqueId()));
                cm.triggerMessage(player.getUniqueId());
            }
            return;
        }
        player.closeInventory();
        player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation(), 40, 0.5, 0.5, 0.5, 0.2);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        Portal finalTarget = target;
        Location targetLoc = finalTarget.getCenterLocation();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> player.teleportAsync(targetLoc).thenRun(() -> {
            targetLoc.getWorld().spawnParticle(Particle.PORTAL, targetLoc, 50, 0.5, 0.5, 0.5, 0.25);
            targetLoc.getWorld().playSound(targetLoc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            MessageUtils.teleport((CommandSender)player, finalTarget.getName());
            cm.triggerTeleport(player.getUniqueId());
        }), 10L);
    }
}

