/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CooldownManager {
    private final Map<UUID, Long> teleportCooldownEnds = new HashMap<UUID, Long>();
    private final Map<UUID, Long> messageCooldownEnds = new HashMap<UUID, Long>();
    private int teleportSeconds;
    private int messageSeconds;

    public CooldownManager(int teleportSeconds, int messageSeconds) {
        this.teleportSeconds = teleportSeconds;
        this.messageSeconds = messageSeconds;
    }

    public void updateConfig(int teleportSeconds, int messageSeconds) {
        this.teleportSeconds = teleportSeconds;
        this.messageSeconds = messageSeconds;
    }

    public boolean canTeleport(UUID uuid) {
        long now = System.currentTimeMillis();
        Long end = this.teleportCooldownEnds.get(uuid);
        return end == null || end <= now;
    }

    public int remainingTeleport(UUID uuid) {
        Long end = this.teleportCooldownEnds.get(uuid);
        if (end == null) {
            return 0;
        }
        long diff = end - System.currentTimeMillis();
        return diff <= 0L ? 0 : (int)Math.ceil((double)diff / 1000.0);
    }

    public void triggerTeleport(UUID uuid) {
        this.teleportCooldownEnds.put(uuid, System.currentTimeMillis() + (long)this.teleportSeconds * 1000L);
    }

    public boolean canMessage(UUID uuid) {
        long now = System.currentTimeMillis();
        Long end = this.messageCooldownEnds.get(uuid);
        return end == null || end <= now;
    }

    public void triggerMessage(UUID uuid) {
        this.messageCooldownEnds.put(uuid, System.currentTimeMillis() + (long)this.messageSeconds * 1000L);
    }
}

