/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.manager;

import com.shweit.etherealportals.manager.IconManager;
import com.shweit.etherealportals.manager.PortalManager;
import com.shweit.etherealportals.model.Portal;
import com.shweit.etherealportals.model.PortalGroup;
import com.shweit.etherealportals.model.PortalIcon;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DataManager {
    private final JavaPlugin plugin;
    private final PortalManager portalManager;
    private final IconManager iconManager;
    private File groupsFile;
    private File iconsFile;
    private FileConfiguration groupsCfg;
    private FileConfiguration iconsCfg;

    public DataManager(JavaPlugin plugin, PortalManager portalManager, IconManager iconManager) {
        this.plugin = plugin;
        this.portalManager = portalManager;
        this.iconManager = iconManager;
        this.init();
    }

    private void init() {
        if (!this.plugin.getDataFolder().exists() && !this.plugin.getDataFolder().mkdirs()) {
            this.plugin.getLogger().warning("Failed to create plugin data folder");
        }
        this.groupsFile = new File(this.plugin.getDataFolder(), "groups.yml");
        this.iconsFile = new File(this.plugin.getDataFolder(), "icons.yml");
        if (!this.groupsFile.exists()) {
            try {
                if (!this.groupsFile.createNewFile()) {
                    this.plugin.getLogger().warning("Failed to create groups.yml");
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("IOException creating groups.yml: " + e.getMessage());
            }
        }
        if (!this.iconsFile.exists()) {
            try {
                if (!this.iconsFile.createNewFile()) {
                    this.plugin.getLogger().warning("Failed to create icons.yml");
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("IOException creating icons.yml: " + e.getMessage());
            }
        }
        this.groupsCfg = YamlConfiguration.loadConfiguration((File)this.groupsFile);
        this.iconsCfg = YamlConfiguration.loadConfiguration((File)this.iconsFile);
        this.loadGroups();
        this.loadIcons();
    }

    private void loadGroups() {
        for (String groupName : this.groupsCfg.getKeys(false)) {
            PortalGroup group = this.portalManager.createGroupIfAbsent(groupName);
            ConfigurationSection groupSection = this.groupsCfg.getConfigurationSection(groupName);
            if (groupSection == null) continue;
            for (String portalName : groupSection.getKeys(false)) {
                ConfigurationSection portalSection;
                World world;
                String path = groupName + "." + portalName;
                String worldName = this.groupsCfg.getString(path + ".world");
                if (worldName == null || (world = Bukkit.getWorld((String)worldName)) == null || (portalSection = this.groupsCfg.getConfigurationSection(path)) == null) continue;
                Portal portal = Portal.deserialize(portalName, portalSection, world);
                group.addPortal(portal);
            }
        }
    }

    private void loadIcons() {
        for (String iconName : this.iconsCfg.getKeys(false)) {
            String base64 = this.iconsCfg.getString(iconName + ".base64");
            if (base64 == null) continue;
            this.iconManager.addIcon(iconName, base64);
        }
    }

    public void saveGroups() {
        YamlConfiguration tmp = new YamlConfiguration();
        for (PortalGroup group : this.portalManager.getGroups()) {
            String groupName = group.getName();
            for (Portal portal : group.getPortals()) {
                String path = groupName + "." + portal.getName();
                portal.serialize(tmp.createSection(path));
            }
        }
        this.groupsCfg = tmp;
        try {
            this.groupsCfg.save(this.groupsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save groups.yml: " + e.getMessage());
        }
    }

    public void saveIcons() {
        YamlConfiguration tmp = new YamlConfiguration();
        for (PortalIcon icon : this.iconManager.getIcons()) {
            String path = icon.getName();
            tmp.set(path + ".base64", (Object)icon.getBase64());
        }
        this.iconsCfg = tmp;
        try {
            this.iconsCfg.save(this.iconsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save icons.yml: " + e.getMessage());
        }
    }
}

