/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals;

import com.shweit.etherealportals.command.EpDebugCommand;
import com.shweit.etherealportals.command.PortalCommand;
import com.shweit.etherealportals.listener.InventoryClickListener;
import com.shweit.etherealportals.listener.InventoryCloseListener;
import com.shweit.etherealportals.listener.PlayerMoveListener;
import com.shweit.etherealportals.listener.PortalItemListener;
import com.shweit.etherealportals.manager.CooldownManager;
import com.shweit.etherealportals.manager.DataManager;
import com.shweit.etherealportals.manager.IconManager;
import com.shweit.etherealportals.manager.PortalManager;
import com.shweit.etherealportals.util.MessageUtils;
import com.shweit.etherealportals.util.PortalItemUtils;
import com.shweit.etherealportals.visual.VisualEffectTask;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EtherealPortals
extends JavaPlugin {
    private PortalManager portalManager;
    private IconManager iconManager;
    private DataManager dataManager;
    private CooldownManager cooldownManager;
    private VisualEffectTask visualTask;
    private double hitboxWidth;
    private double hitboxDepth;
    private double hitboxHeight;
    private boolean craftablePortalsEnabled;
    private String defaultPortalTexture;
    private String portalItemName;
    private List<String> portalItemLore;

    public PortalManager getPortalManager() {
        return this.portalManager;
    }

    public IconManager getIconManager() {
        return this.iconManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public VisualEffectTask getVisualTask() {
        return this.visualTask;
    }

    public double getHitboxWidth() {
        return this.hitboxWidth;
    }

    public double getHitboxDepth() {
        return this.hitboxDepth;
    }

    public double getHitboxHeight() {
        return this.hitboxHeight;
    }

    public boolean isCraftablePortalsEnabled() {
        return this.craftablePortalsEnabled;
    }

    public String getDefaultPortalTexture() {
        return this.defaultPortalTexture;
    }

    public String getPortalItemName() {
        return this.portalItemName;
    }

    public List<String> getPortalItemLore() {
        return this.portalItemLore;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadLocalConfig();
        this.portalManager = new PortalManager();
        this.iconManager = new IconManager();
        this.cooldownManager = new CooldownManager(this.getConfig().getInt("portal.teleport.cooldownSeconds", 3), this.getConfig().getInt("portal.teleport.messageCooldownSeconds", 1));
        this.dataManager = new DataManager(this, this.portalManager, this.iconManager);
        this.registerCommands();
        this.registerListeners();
        this.registerCraftingRecipe();
        this.visualTask = new VisualEffectTask(this);
        this.visualTask.start();
        MessageUtils.send((CommandSender)this.getServer().getConsoleSender(), "Plugin enabled.");
    }

    public void onDisable() {
        this.dataManager.saveGroups();
        this.dataManager.saveIcons();
        if (this.visualTask != null) {
            this.visualTask.stop();
        }
    }

    public void reloadLocalConfig() {
        this.reloadConfig();
        this.hitboxWidth = this.getConfig().getDouble("portal.hitbox.width", 2.0);
        this.hitboxDepth = this.getConfig().getDouble("portal.hitbox.depth", 2.0);
        this.hitboxHeight = this.getConfig().getDouble("portal.hitbox.height", 2.0);
        this.craftablePortalsEnabled = this.getConfig().getBoolean("portal.craftablePortals.enabled", true);
        this.defaultPortalTexture = this.getConfig().getString("portal.defaultTexture", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjBiZmMyNTc3ZjZlMjZjNmM2ZjczNjVjMmM0MDc2YmNjZWU2NTMxMjQ5ODkzODJjZTkzYmNhNGZjOWUzOWIifX19");
        this.portalItemName = this.getConfig().getString("portal.craftablePortals.item.name", "\u00a7d\u00a7lPortal Crystal");
        this.portalItemLore = this.getConfig().getStringList("portal.craftablePortals.item.lore");
        if (this.cooldownManager != null) {
            this.cooldownManager.updateConfig(this.getConfig().getInt("portal.teleport.cooldownSeconds", 3), this.getConfig().getInt("portal.teleport.messageCooldownSeconds", 1));
        }
    }

    private void registerCommands() {
        PluginCommand debugCmd;
        PluginCommand portalCmd = this.getCommand("portal");
        if (portalCmd != null) {
            PortalCommand executor = new PortalCommand(this);
            portalCmd.setExecutor((CommandExecutor)executor);
            portalCmd.setTabCompleter((TabCompleter)executor);
        }
        if ((debugCmd = this.getCommand("epdebug")) != null) {
            EpDebugCommand debugExecutor = new EpDebugCommand(this);
            debugCmd.setExecutor((CommandExecutor)debugExecutor);
            debugCmd.setTabCompleter((TabCompleter)debugExecutor);
        }
    }

    private void registerListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        pm.registerEvents((Listener)new InventoryClickListener(this), (Plugin)this);
        pm.registerEvents((Listener)new InventoryCloseListener(), (Plugin)this);
        pm.registerEvents((Listener)new PortalItemListener(this), (Plugin)this);
    }

    private void registerCraftingRecipe() {
        if (!this.craftablePortalsEnabled) {
            return;
        }
        ItemStack result = PortalItemUtils.createPortalItem((Plugin)this, this.defaultPortalTexture, this.portalItemName, this.portalItemLore);
        NamespacedKey key = new NamespacedKey((Plugin)this, "portal_crystal");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"ECE", "ASA", "ECE"});
        recipe.setIngredient('E', Material.ENDER_PEARL);
        recipe.setIngredient('C', Material.CRYING_OBSIDIAN);
        recipe.setIngredient('A', Material.AMETHYST_SHARD);
        recipe.setIngredient('S', Material.NETHER_STAR);
        this.getServer().addRecipe((Recipe)recipe);
    }
}

