/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.listener;

import com.shweit.etherealportals.EtherealPortals;
import com.shweit.etherealportals.manager.PortalManager;
import com.shweit.etherealportals.model.Portal;
import com.shweit.etherealportals.model.PortalGroup;
import com.shweit.etherealportals.util.MessageUtils;
import com.shweit.etherealportals.util.PortalItemUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PortalItemListener
implements Listener {
    private final EtherealPortals plugin;

    public PortalItemListener(EtherealPortals plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        String portalName;
        boolean added;
        String groupBaseName;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (!PortalItemUtils.isPortalItem((Plugin)this.plugin, item)) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        if (!this.plugin.isCraftablePortalsEnabled()) {
            MessageUtils.error((CommandSender)player, "Craftable portals are disabled on this server.");
            return;
        }
        if (!player.hasPermission("portal.item.place")) {
            MessageUtils.error((CommandSender)player, "You don't have permission to place portal items.");
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        Location loc = clickedBlock.getLocation().add(0.0, 1.0, 0.0);
        String displayName = item.getItemMeta().getDisplayName();
        String stripped = ChatColor.stripColor((String)displayName);
        if (stripped == null || stripped.isEmpty()) {
            groupBaseName = "portals";
        } else {
            groupBaseName = stripped.replace(":", "").replace(" ", "_").trim();
            if (groupBaseName.isEmpty()) {
                groupBaseName = "portals";
            }
        }
        String groupName = player.getName().toLowerCase() + ":" + groupBaseName.toLowerCase();
        PortalManager pm = this.plugin.getPortalManager();
        PortalGroup group = pm.getGroup(groupName);
        int maxNumber = 0;
        if (group != null) {
            for (Portal p : group.getPortals()) {
                try {
                    int num = Integer.parseInt(p.getName());
                    if (num <= maxNumber) continue;
                    maxNumber = num;
                }
                catch (NumberFormatException num) {}
            }
        }
        if (!(added = pm.addPortal(groupName, portalName = String.valueOf(maxNumber + 1), loc, null, true))) {
            MessageUtils.error((CommandSender)player, "Failed to create portal. Please try again.");
            return;
        }
        this.plugin.getDataManager().saveGroups();
        Location textLoc = loc.clone().add(0.5, 3.0, 0.5);
        Location markerLoc = loc.clone().add(0.5, 0.0, 0.5);
        String displayNameForText = groupBaseName + " #" + portalName;
        this.plugin.getVisualTask().createTextDisplay(textLoc, groupName, portalName, displayNameForText);
        this.plugin.getVisualTask().createArmorStandMarker(markerLoc, groupName, portalName);
        loc.getWorld().spawnParticle(Particle.PORTAL, loc.clone().add(0.5, 0.5, 0.5), 40, 0.3, 0.3, 0.3, 0.5);
        item.setAmount(item.getAmount() - 1);
        int totalPortals = pm.getGroup(groupName).getPortals().size();
        MessageUtils.success((CommandSender)player, "Portal &d#" + portalName + "&a created in group &d" + groupBaseName + "&a! (" + totalPortals + " total)");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof ArmorStand)) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)event.getEntity();
        String tag = armorStand.getScoreboardTags().stream().filter(t -> t.startsWith("ep_portal_marker:")).findFirst().orElse(null);
        if (tag == null) {
            return;
        }
        event.setCancelled(true);
        String remaining = tag.substring("ep_portal_marker:".length());
        int lastColon = remaining.lastIndexOf(58);
        if (lastColon == -1) {
            this.plugin.getLogger().warning("Invalid portal marker tag format: " + tag);
            return;
        }
        String groupName = remaining.substring(0, lastColon);
        String portalName = remaining.substring(lastColon + 1);
        PortalManager pm = this.plugin.getPortalManager();
        PortalGroup group = pm.getGroup(groupName);
        if (group == null) {
            return;
        }
        Portal portal = group.getPortal(portalName);
        if (portal == null) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!portal.isBreakable()) {
            MessageUtils.error((CommandSender)player, "This portal cannot be broken.");
            return;
        }
        if (!player.hasPermission("portal.item.break")) {
            MessageUtils.error((CommandSender)player, "You don't have permission to break portal items.");
            return;
        }
        this.plugin.getVisualTask().removeTextDisplay(groupName, portalName, portal);
        group.removePortal(portalName);
        if (group.getPortals().isEmpty()) {
            pm.deleteGroup(groupName);
        }
        this.plugin.getDataManager().saveGroups();
        ItemStack droppedItem = PortalItemUtils.createPortalItem((Plugin)this.plugin, this.plugin.getDefaultPortalTexture(), this.plugin.getPortalItemName(), this.plugin.getPortalItemLore());
        armorStand.getWorld().dropItemNaturally(armorStand.getLocation(), droppedItem);
        armorStand.getWorld().spawnParticle(Particle.PORTAL, armorStand.getLocation(), 40, 0.3, 0.3, 0.3, 0.5);
        MessageUtils.success((CommandSender)player, "Portal &d" + portal.getName() + "&a removed!");
    }
}

