/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.manager;

import com.shweit.etherealportals.model.Portal;
import com.shweit.etherealportals.model.PortalGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.World;

public class PortalManager {
    private final Map<String, PortalGroup> groups = new LinkedHashMap<String, PortalGroup>();

    public Collection<PortalGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public PortalGroup getGroup(String name) {
        return this.groups.get(name.toLowerCase());
    }

    public PortalGroup createGroupIfAbsent(String name) {
        return this.groups.computeIfAbsent(name.toLowerCase(), k -> new PortalGroup(name));
    }

    public boolean deleteGroup(String name) {
        return this.groups.remove(name.toLowerCase()) != null;
    }

    public boolean addPortal(String groupName, String portalName, Location loc, String icon) {
        return this.addPortal(groupName, portalName, loc, icon, false);
    }

    public boolean addPortal(String groupName, String portalName, Location loc, String icon, boolean breakable) {
        PortalGroup group = this.createGroupIfAbsent(groupName);
        return group.addPortal(new Portal(portalName, loc, icon, breakable));
    }

    public boolean removePortal(String groupName, String portalName) {
        PortalGroup group = this.getGroup(groupName);
        if (group == null) {
            return false;
        }
        boolean removed = group.removePortal(portalName);
        if (!removed || group.isEmpty()) {
            // empty if block
        }
        return removed;
    }

    public PortalResult findPortalAt(Location playerLoc, double width, double depth, double height) {
        World world = playerLoc.getWorld();
        for (PortalGroup group : this.groups.values()) {
            for (Portal portal : group.getPortals()) {
                Location base = portal.getBaseLocation();
                if (!Objects.equals(world, base.getWorld())) continue;
                double minX = base.getX() - (width - 1.0) / 2.0;
                double maxX = base.getX() + (width + 1.0) / 2.0;
                double minY = base.getY();
                double maxY = base.getY() + height;
                double minZ = base.getZ() - (depth - 1.0) / 2.0;
                double maxZ = base.getZ() + (depth + 1.0) / 2.0;
                double x = playerLoc.getX();
                double y = playerLoc.getY();
                double z = playerLoc.getZ();
                if (!(x >= minX) || !(x <= maxX) || !(y >= minY) || !(y <= maxY) || !(z >= minZ) || !(z <= maxZ)) continue;
                return new PortalResult(portal, group);
            }
        }
        return null;
    }

    public static class PortalResult {
        private final Portal portal;
        private final PortalGroup group;

        public PortalResult(Portal portal, PortalGroup group) {
            this.portal = portal;
            this.group = group;
        }

        public Portal getPortal() {
            return this.portal;
        }

        public PortalGroup getGroup() {
            return this.group;
        }
    }
}

