/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.util;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class MessageUtils {
    private static final String PREFIX = String.valueOf(ChatColor.DARK_PURPLE) + "[" + String.valueOf(ChatColor.LIGHT_PURPLE) + "Ethereal Portals" + String.valueOf(ChatColor.DARK_PURPLE) + "]" + String.valueOf(ChatColor.RESET) + " ";

    private MessageUtils() {
    }

    public static void send(CommandSender sender, String msg) {
        sender.sendMessage(PREFIX + ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
    }

    public static void success(CommandSender sender, String msg) {
        sender.sendMessage(PREFIX + String.valueOf(ChatColor.GREEN) + ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
    }

    public static void error(CommandSender sender, String msg) {
        sender.sendMessage(PREFIX + String.valueOf(ChatColor.RED) + ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
    }

    public static void info(CommandSender sender, String msg) {
        sender.sendMessage(PREFIX + String.valueOf(ChatColor.GRAY) + ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
    }

    public static void warning(CommandSender sender, String msg) {
        sender.sendMessage(PREFIX + String.valueOf(ChatColor.YELLOW) + ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
    }

    public static void teleport(CommandSender sender, String portalName) {
        sender.sendMessage(PREFIX + String.valueOf(ChatColor.GRAY) + "Teleporting to " + String.valueOf(ChatColor.LIGHT_PURPLE) + portalName + String.valueOf(ChatColor.GRAY) + "...");
    }

    public static void cooldown(CommandSender sender, long seconds) {
        sender.sendMessage(PREFIX + String.valueOf(ChatColor.YELLOW) + "Please wait " + String.valueOf(ChatColor.GOLD) + seconds + "s" + String.valueOf(ChatColor.YELLOW) + " before teleporting again.");
    }

    public static String formatCoords(Location loc) {
        return String.format("x=%.1f y=%.1f z=%.1f", loc.getX(), loc.getY(), loc.getZ());
    }

    public static double parseRelative(Player player, String token, double base) {
        if (token.startsWith("~")) {
            if (token.length() == 1) {
                return base;
            }
            try {
                return base + Double.parseDouble(token.substring(1));
            }
            catch (NumberFormatException e) {
                return base;
            }
        }
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException e) {
            return base;
        }
    }
}

