/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.util;

import com.shweit.etherealportals.util.SkullUtils;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class PortalItemUtils {
    private PortalItemUtils() {
    }

    public static ItemStack createPortalItem(Plugin plugin, String texture, String displayName, List<String> lore) {
        ItemStack item = SkullUtils.createHead(texture, displayName);
        ItemMeta meta = item.getItemMeta();
        if (lore != null && !lore.isEmpty()) {
            meta.setLore(lore);
        }
        NamespacedKey key = new NamespacedKey(plugin, "portal_item");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"true");
        if (!item.setItemMeta(meta)) {
            System.err.println("Failed to set portal item meta");
        }
        return item;
    }

    public static boolean isPortalItem(Plugin plugin, ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey(plugin, "portal_item");
        return meta.getPersistentDataContainer().has(key, PersistentDataType.STRING);
    }
}

