/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.etherealportals.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public final class SkullUtils {
    private SkullUtils() {
    }

    public static ItemStack createHead(String base64, String displayName) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (displayName != null) {
            meta.setDisplayName(displayName);
        }
        if (base64 != null && !base64.isEmpty()) {
            try {
                UUID textureUuid = UUID.nameUUIDFromBytes(base64.getBytes(StandardCharsets.UTF_8));
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)textureUuid, (String)"");
                PlayerTextures textures = profile.getTextures();
                String textureUrl = SkullUtils.getTextureUrlFromBase64(base64);
                if (textureUrl != null) {
                    textures.setSkin(new URL(textureUrl));
                    profile.setTextures(textures);
                    meta.setOwnerProfile(profile);
                }
            }
            catch (MalformedURLException e) {
                System.err.println("Invalid texture URL: " + e.getMessage());
            }
        }
        if (!head.setItemMeta((ItemMeta)meta)) {
            System.err.println("Failed to set skull meta");
        }
        return head;
    }

    private static String getTextureUrlFromBase64(String base64) {
        try {
            String decoded = new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
            int urlStart = decoded.indexOf("\"url\":\"") + 7;
            int urlEnd = decoded.indexOf("\"", urlStart);
            if (urlStart > 6 && urlEnd > urlStart) {
                return decoded.substring(urlStart, urlEnd);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to parse base64 texture: " + e.getMessage());
        }
        return null;
    }
}

