/*
 * Decompiled with CFR 0.152.
 */
package dev.louis.anchorteleportsystem.data;

import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_4208;
import net.minecraft.class_5699;
import net.minecraft.server.MinecraftServer;

public class TeleporterState
extends class_18 {
    private HashBiMap<class_4208, class_4208> teleporters;
    public static final Codec<TeleporterState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_53703((Codec)class_4208.field_25066, (Codec)class_4208.field_25066).fieldOf("links").forGetter(teleporterState -> teleporterState.teleporters)).apply((Applicative)instance, TeleporterState::new));

    protected TeleporterState() {
    }

    public TeleporterState(Map<class_4208, class_4208> map) {
        this.teleporters = HashBiMap.create(map);
    }

    public Optional<class_4208> getLinkedTeleporter(class_4208 GlobalPos) {
        class_4208 GlobalPos1 = (class_4208)this.teleporters.get((Object)GlobalPos);
        if (GlobalPos1 != null) {
            return Optional.of(GlobalPos1);
        }
        class_4208 GlobalPos2 = (class_4208)this.teleporters.inverse().get((Object)GlobalPos);
        if (GlobalPos2 != null) {
            return Optional.of(GlobalPos2);
        }
        return Optional.empty();
    }

    public void removeLink(class_4208 GlobalPos) {
        this.teleporters.remove((Object)GlobalPos);
        this.teleporters.inverse().remove((Object)GlobalPos);
        this.method_80();
    }

    public boolean doesLinkExist(class_4208 GlobalPos) {
        return this.teleporters.containsKey((Object)GlobalPos) || this.teleporters.containsValue((Object)GlobalPos);
    }

    public boolean link(class_4208 GlobalPos1, class_4208 GlobalPos2) {
        this.teleporters.put((Object)GlobalPos1, (Object)GlobalPos2);
        this.method_80();
        return true;
    }

    public static TeleporterState getServerState(MinecraftServer server) {
        class_26 persistentStateManager = server.method_3847(class_1937.field_25179).method_17983();
        TeleporterState teleporterState = (TeleporterState)persistentStateManager.method_17924(new class_10741("anchorteleportsystem-teleporters", TeleporterState::new, CODEC, null));
        if (teleporterState.teleporters == null) {
            teleporterState.teleporters = HashBiMap.create();
        }
        return teleporterState;
    }
}

