/*
 * Decompiled with CFR 0.152.
 */
package com.kitawadesu.create_mpnt.blocks.entities.util.tanks.entity;

import com.kitawadesu.create_mpnt.blocks.entities.CreateMPNTBlockEntities;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BrassFluidTankBlockEntity
extends FluidTankBlockEntity
implements IMultiBlockEntityContainer {
    public BrassFluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int getTankHeight() {
        return this.height;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CreateMPNTBlockEntities.BRASS_FLUID_TANK.get(), (be, context) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
    }

    void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? (this.boiler.isActive() ? this.boiler.createHandler() : this.tankInventory) : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    @Nullable
    public BrassFluidTankBlockEntity getOtherFluidTankBlockEntity(Direction direction) {
        BlockEntity otherBE = this.level.getBlockEntity(this.worldPosition.relative(direction));
        if (otherBE instanceof BrassFluidTankBlockEntity) {
            return (BrassFluidTankBlockEntity)otherBE;
        }
        return null;
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public BrassFluidTankBlockEntity getControllerBE() {
        if (this.isController() || !this.hasLevel()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof BrassFluidTankBlockEntity) {
            return (BrassFluidTankBlockEntity)blockEntity;
        }
        return null;
    }
}

