/*
 * Decompiled with CFR 0.152.
 */
package com.kitawadesu.create_mpnt.util.datagen;

import com.kitawadesu.create_mpnt.blocks.CreateMPNTBlocks;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class CMPNTRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final Item ELECTRON_TUBE = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"electron_tube"));
    private static final Item DRIED_KELP = Items.DRIED_KELP;

    public CMPNTRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.createSmartFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.SMART_COPPER_FUNNEL.get())), Items.COPPER_INGOT, "copper");
        this.createSmartFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.SMART_IRON_FUNNEL.get())), Items.IRON_INGOT, "iron");
        this.createSmartFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.SMART_GOLDEN_FUNNEL.get())), Items.GOLD_INGOT, "gold");
        this.createSmartFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.SMART_NETHERITE_FUNNEL.get())), Items.NETHERITE_INGOT, "netherite");
        this.createSmartFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.SMART_ZINC_FUNNEL.get())), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"zinc_ingot")), "zinc");
        this.createSmartFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.SMART_ANDESITE_FUNNEL.get())), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"andesite_alloy")), "andesite_alloy");
        this.createNormalFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.NORMAL_COPPER_FUNNEL.get())), Items.COPPER_INGOT, "copper");
        this.createNormalFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.NORMAL_IRON_FUNNEL.get())), Items.IRON_INGOT, "iron");
        this.createNormalFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.NORMAL_GOLDEN_FUNNEL.get())), Items.GOLD_INGOT, "gold");
        this.createNormalFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.NORMAL_NETHERITE_FUNNEL.get())), Items.NETHERITE_INGOT, "netherite");
        this.createNormalFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.NORMAL_ZINC_FUNNEL.get())), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"zinc_ingot")), "zinc");
        this.createNormalFunnel(recipeOutput, Item.byBlock((Block)((Block)CreateMPNTBlocks.NORMAL_BRASS_FUNNEL.get())), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"brass_ingot")), "brass");
    }

    private void createSmartFunnel(RecipeOutput recipeOutput, Item funnel, Item ingot, String unlockName) {
        if (funnel == null || ingot == null) {
            return;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)funnel).pattern(" T ").pattern(" I ").pattern(" K ").define(Character.valueOf('T'), (ItemLike)ELECTRON_TUBE).define(Character.valueOf('K'), (ItemLike)DRIED_KELP).define(Character.valueOf('I'), (ItemLike)ingot).unlockedBy("has_" + unlockName, CMPNTRecipeProvider.has((ItemLike)ingot)).save(recipeOutput);
    }

    private void createNormalFunnel(RecipeOutput recipeOutput, Item funnel, Item ingot, String unlockName) {
        if (funnel == null || ingot == null) {
            return;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)funnel).pattern(" I ").pattern(" K ").define(Character.valueOf('K'), (ItemLike)DRIED_KELP).define(Character.valueOf('I'), (ItemLike)ingot).unlockedBy("has_" + unlockName, CMPNTRecipeProvider.has((ItemLike)ingot)).save(recipeOutput);
    }
}

