/*
 * Decompiled with CFR 0.152.
 */
package com.kitawadesu.create_mpnt.util.mixins;

import com.kitawadesu.create_mpnt.blocks.CreateMPNTBlocks;
import com.kitawadesu.create_mpnt.util.mixins.BeltInventoryAccessor;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.BeltInventory;
import com.simibubi.create.content.kinetics.belt.transport.BeltTunnelInteractionHandler;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlock;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.redstone.displayLink.source.AccumulatedItemCountDisplaySource;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BeltTunnelInteractionHandler.class})
public class BeltTunnelInteractionHandlerMixin {
    @Overwrite
    public static boolean flapTunnelsAndCheckIfStuck(BeltInventory beltInventory, TransportedItemStack current, float nextOffset) {
        BeltBlockEntity belt = ((BeltInventoryAccessor)beltInventory).getBelt();
        boolean positive = ((BeltInventoryAccessor)beltInventory).isBeltMovementPositive();
        int currentSegment = (int)current.beltPosition;
        int upcomingSegment = (int)nextOffset;
        Direction movementFacing = belt.getMovementFacing();
        if (!positive && nextOffset == 0.0f) {
            upcomingSegment = -1;
        }
        if (currentSegment == upcomingSegment) {
            return false;
        }
        if (BeltTunnelInteractionHandlerMixin.stuckAtTunnel(beltInventory, upcomingSegment, current.stack, movementFacing)) {
            current.beltPosition = (float)currentSegment + (positive ? 0.99f : 0.01f);
            return true;
        }
        Level world = belt.getLevel();
        boolean onServer = !world.isClientSide || belt.isVirtual();
        boolean removed = false;
        BeltTunnelBlockEntity nextTunnel = BeltTunnelInteractionHandlerMixin.getTunnelOnSegment(beltInventory, upcomingSegment);
        int transferred = current.stack.getCount();
        if (nextTunnel instanceof BrassTunnelBlockEntity) {
            BrassTunnelBlockEntity brassTunnel = (BrassTunnelBlockEntity)nextTunnel;
            if (brassTunnel.hasDistributionBehaviour()) {
                if (!brassTunnel.canTakeItems()) {
                    return true;
                }
                if (onServer) {
                    brassTunnel.setStackToDistribute(current.stack, movementFacing.getOpposite());
                    current.stack = ItemStack.EMPTY;
                    belt.notifyUpdate();
                }
                removed = true;
            }
        } else if (nextTunnel != null) {
            BlockState blockState = nextTunnel.getBlockState();
            if (current.stack.getCount() > 1 && BeltTunnelInteractionHandlerMixin.isRecognizedTunnelBlock(blockState) && BeltTunnelBlock.isJunction((BlockState)blockState) && movementFacing.getAxis() == blockState.getValue(BeltTunnelBlock.HORIZONTAL_AXIS)) {
                for (Direction d : Iterate.horizontalDirections) {
                    if (d.getAxis() == blockState.getValue(BeltTunnelBlock.HORIZONTAL_AXIS) || !nextTunnel.flaps.containsKey(d)) continue;
                    BlockPos outpos = nextTunnel.getBlockPos().below().relative(d);
                    if (!world.isLoaded(outpos)) {
                        return true;
                    }
                    DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)outpos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
                    if (behaviour == null || !behaviour.canInsertFromSide(d)) continue;
                    ItemStack toinsert = current.stack.copyWithCount(1);
                    if (!behaviour.handleInsertion(toinsert, d, false).isEmpty()) {
                        return true;
                    }
                    if (onServer) {
                        BeltTunnelInteractionHandlerMixin.flapTunnel(beltInventory, upcomingSegment, d, false);
                    }
                    current.stack.shrink(1);
                    belt.notifyUpdate();
                    if (current.stack.getCount() <= 1) break;
                }
            }
        }
        if (onServer) {
            BeltTunnelInteractionHandlerMixin.flapTunnel(beltInventory, currentSegment, movementFacing, false);
            BeltTunnelInteractionHandlerMixin.flapTunnel(beltInventory, upcomingSegment, movementFacing.getOpposite(), true);
            if (nextTunnel != null) {
                DisplayLinkBlock.sendToGatherers((LevelAccessor)world, (BlockPos)nextTunnel.getBlockPos(), (dgte, b) -> b.itemReceived(dgte, transferred), AccumulatedItemCountDisplaySource.class);
            }
        }
        return removed;
    }

    @Shadow
    public static boolean stuckAtTunnel(BeltInventory beltInventory, int offset, ItemStack stack, Direction movementDirection) {
        BeltBlockEntity belt = ((BeltInventoryAccessor)beltInventory).getBelt();
        BlockPos pos = BeltHelper.getPositionForOffset((BeltBlockEntity)belt, (int)offset).above();
        if (!(belt.getLevel().getBlockState(pos).getBlock() instanceof BrassTunnelBlock)) {
            return false;
        }
        BlockEntity be = belt.getLevel().getBlockEntity(pos);
        if (be == null || !(be instanceof BrassTunnelBlockEntity)) {
            return false;
        }
        BrassTunnelBlockEntity tunnel = (BrassTunnelBlockEntity)be;
        return !tunnel.canInsert(movementDirection.getOpposite(), stack);
    }

    @Shadow
    public static void flapTunnel(BeltInventory beltInventory, int offset, Direction side, boolean inward) {
        BeltTunnelBlockEntity be = BeltTunnelInteractionHandlerMixin.getTunnelOnSegment(beltInventory, offset);
        if (be == null) {
            return;
        }
        be.flap(side, inward);
    }

    @Shadow
    protected static BeltTunnelBlockEntity getTunnelOnSegment(BeltInventory beltInventory, int offset) {
        BeltBlockEntity belt = ((BeltInventoryAccessor)beltInventory).getBelt();
        if (belt.getBlockState().getValue(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL) {
            return null;
        }
        return BeltTunnelInteractionHandlerMixin.getTunnelOnPosition(belt.getLevel(), BeltHelper.getPositionForOffset((BeltBlockEntity)belt, (int)offset));
    }

    @Shadow
    public static BeltTunnelBlockEntity getTunnelOnPosition(Level world, BlockPos pos) {
        if (!(world.getBlockState(pos = pos.above()).getBlock() instanceof BeltTunnelBlock)) {
            return null;
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (be == null || !(be instanceof BeltTunnelBlockEntity)) {
            return null;
        }
        return (BeltTunnelBlockEntity)be;
    }

    private static boolean isRecognizedTunnelBlock(BlockState state) {
        return AllBlocks.ANDESITE_TUNNEL.has(state) || state.is((Block)CreateMPNTBlocks.NORMAL_NETHERITE_TUNNEL.get()) || state.is((Block)CreateMPNTBlocks.NORMAL_BRASS_TUNNEL.get()) || state.is((Block)CreateMPNTBlocks.NORMAL_COPPER_TUNNEL.get()) || state.is((Block)CreateMPNTBlocks.NORMAL_GOLDEN_TUNNEL.get()) || state.is((Block)CreateMPNTBlocks.NORMAL_IRON_TUNNEL.get()) || state.is((Block)CreateMPNTBlocks.NORMAL_ZINC_TUNNEL.get()) || state.is((Block)CreateMPNTBlocks.NORMAL_ROSE_GOLDEN_TUNNEL.get()) || state.is((Block)CreateMPNTBlocks.NORMAL_ROSARITE_TUNNEL.get()) || state.is((Block)CreateMPNTBlocks.NORMAL_VALKYRUM_TUNNEL.get()) || state.is((Block)CreateMPNTBlocks.NORMAL_PYRAL_TUNNEL.get());
    }
}

