/*
 * Decompiled with CFR 0.152.
 */
package com.kitawadesu.create_mpnt.util.mixins;

import com.kitawadesu.create_mpnt.blocks.CreateMPNTBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.AxisPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FluidPropagator.class})
public class FluidPropagatorMixin {
    @Shadow
    public static CreateAdvancement[] getSharedTriggers() {
        return new CreateAdvancement[]{AllAdvancements.WATER_SUPPLY, AllAdvancements.CROSS_STREAMS, AllAdvancements.HONEY_DRAIN};
    }

    @Overwrite(remap=false)
    public static void propagateChangedPipe(LevelAccessor world, BlockPos pipePos, BlockState pipeState) {
        ArrayList<Pair> frontier = new ArrayList<Pair>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<Pair> discoveredPumps = new HashSet<Pair>();
        frontier.add(Pair.of((Object)0, (Object)pipePos));
        while (!frontier.isEmpty()) {
            BlockState currentState;
            Pair pair = (Pair)frontier.remove(0);
            BlockPos currentPos = (BlockPos)pair.getSecond();
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            BlockState blockState = currentState = currentPos.equals((Object)pipePos) ? pipeState : world.getBlockState(currentPos);
            FluidTransportBehaviour pipe = FluidPropagatorMixin.getPipe((BlockGetter)world, currentPos);
            if (pipe == null) continue;
            pipe.wipePressure();
            for (Direction direction : FluidPropagatorMixin.getPipeConnections(currentState, pipe)) {
                Integer distance;
                FluidTransportBehaviour targetPipe;
                Level l;
                BlockPos target = currentPos.relative(direction);
                if (world instanceof Level && !(l = (Level)world).isLoaded(target)) continue;
                BlockEntity tileEntity = world.getBlockEntity(target);
                BlockState targetState = world.getBlockState(target);
                if (tileEntity instanceof PumpBlockEntity) {
                    boolean isMoreStuffLoaded = ModList.get().isLoaded("more_stuff");
                    boolean isVanillaPump = AllBlocks.MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.ZINC_MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.GOLDEN_MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.ANDESITE_MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.BRASS_MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.IRON_MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.NETHERITE_MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.ROSE_GOLDEN_MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.ROSARITE_MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.VALKYRUM_MECHANICAL_PUMP.has(targetState) || CreateMPNTBlocks.PYRAL_MECHANICAL_PUMP.has(targetState);
                    if (!isVanillaPump || ((Direction)targetState.getValue((Property)PumpBlock.FACING)).getAxis() != direction.getAxis()) continue;
                    discoveredPumps.add(Pair.of((Object)((PumpBlockEntity)tileEntity), (Object)direction.getOpposite()));
                    continue;
                }
                if (visited.contains(target) || (targetPipe = FluidPropagatorMixin.getPipe((BlockGetter)world, target)) == null || (distance = (Integer)pair.getFirst()) >= FluidPropagatorMixin.getPumpRange() && !targetPipe.hasAnyPressure() || !targetPipe.canHaveFlowToward(targetState, direction.getOpposite())) continue;
                frontier.add(Pair.of((Object)(distance + 1), (Object)target));
            }
        }
        discoveredPumps.forEach(pairx -> ((PumpBlockEntity)pairx.getFirst()).updatePipesOnSide((Direction)pairx.getSecond()));
    }

    @Shadow
    public static Direction validateNeighbourChange(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        if (world.isClientSide) {
            return null;
        }
        otherBlock = world.getBlockState(neighborPos).getBlock();
        if (otherBlock instanceof FluidPipeBlock) {
            return null;
        }
        if (otherBlock instanceof AxisPipeBlock) {
            return null;
        }
        if (otherBlock instanceof PumpBlock) {
            return null;
        }
        if (otherBlock instanceof LiquidBlock) {
            return null;
        }
        if (FluidPropagatorMixin.getStraightPipeAxis(state) == null && !AllBlocks.ENCASED_FLUID_PIPE.has(state)) {
            return null;
        }
        for (Direction d : Iterate.directions) {
            if (!pos.relative(d).equals((Object)neighborPos)) continue;
            return d;
        }
        return null;
    }

    @Shadow
    public static FluidTransportBehaviour getPipe(BlockGetter reader, BlockPos pos) {
        return (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockGetter)reader, (BlockPos)pos, (BehaviourType)FluidTransportBehaviour.TYPE);
    }

    @Shadow
    public static boolean isOpenEnd(BlockGetter reader, BlockPos pos, Direction side) {
        BlockPos connectedPos = pos.relative(side);
        BlockState connectedState = reader.getBlockState(connectedPos);
        FluidTransportBehaviour pipe = FluidPropagatorMixin.getPipe(reader, connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, side.getOpposite())) {
            return false;
        }
        if (PumpBlock.isPump((BlockState)connectedState) && ((Direction)connectedState.getValue((Property)PumpBlock.FACING)).getAxis() == side.getAxis()) {
            return false;
        }
        if (VanillaFluidTargets.canProvideFluidWithoutCapability((BlockState)connectedState)) {
            return true;
        }
        if (BlockHelper.hasBlockSolidSide((BlockState)connectedState, (BlockGetter)reader, (BlockPos)connectedPos, (Direction)side.getOpposite()) && !AllTags.AllBlockTags.FAN_TRANSPARENT.matches(connectedState)) {
            return false;
        }
        if (FluidPropagatorMixin.hasFluidCapability(reader, connectedPos, side.getOpposite())) {
            return false;
        }
        return connectedState.canBeReplaced() && connectedState.getDestroySpeed(reader, connectedPos) != -1.0f || connectedState.hasProperty((Property)BlockStateProperties.WATERLOGGED);
    }

    @Shadow
    public static List<Direction> getPipeConnections(BlockState state, FluidTransportBehaviour pipe) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction d : Iterate.directions) {
            if (!pipe.canHaveFlowToward(state, d)) continue;
            list.add(d);
        }
        return list;
    }

    @Shadow
    public static int getPumpRange() {
        return (Integer)AllConfigs.server().fluids.mechanicalPumpRange.get();
    }

    @Shadow
    public static boolean hasFluidCapability(BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null && blockEntity.getLevel() != null) {
            IFluidHandler capability = (IFluidHandler)blockEntity.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, blockEntity.getBlockPos(), (Object)side);
            return capability != null;
        }
        return false;
    }

    @Shadow
    @Nullable
    public static Direction.Axis getStraightPipeAxis(BlockState state) {
        if (state.getBlock() instanceof PumpBlock) {
            return ((Direction)state.getValue((Property)PumpBlock.FACING)).getAxis();
        }
        if (state.getBlock() instanceof AxisPipeBlock) {
            return (Direction.Axis)state.getValue((Property)AxisPipeBlock.AXIS);
        }
        if (!FluidPipeBlock.isPipe((BlockState)state)) {
            return null;
        }
        Direction.Axis axisFound = null;
        int connections = 0;
        for (Direction.Axis axis : Iterate.axes) {
            Direction d1 = Direction.get((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
            Direction d2 = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
            boolean openAt1 = FluidPipeBlock.isOpenAt((BlockState)state, (Direction)d1);
            boolean openAt2 = FluidPipeBlock.isOpenAt((BlockState)state, (Direction)d2);
            if (openAt1) {
                ++connections;
            }
            if (openAt2) {
                ++connections;
            }
            if (!openAt1 || !openAt2) continue;
            if (axisFound != null) {
                return null;
            }
            axisFound = axis;
        }
        return connections == 2 ? axisFound : null;
    }
}

