/*
 * Decompiled with CFR 0.152.
 */
package com.kitawadesu.create_mpnt.util.mixins;

import com.kitawadesu.create_mpnt.blocks.entities.CreateMPNTBlockEntities;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={FluidTankItem.class})
public class FluidTankItemMixin
extends BlockItem {
    public FluidTankItemMixin(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult place(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.place(ctx);
        if (!initialResult.consumesAction()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.getPlayer();
        if (player == null) {
            return;
        }
        if (player.isShiftKeyDown()) {
            return;
        }
        Direction face = ctx.getClickedFace();
        if (!face.getAxis().isVertical()) {
            return;
        }
        ItemStack stack = ctx.getItemInHand();
        Level world = ctx.getLevel();
        BlockState placedOnState = world.getBlockState(placedOnPos = (pos = ctx.getClickedPos()).relative(face.getOpposite()));
        if (!FluidTankBlock.isTank((BlockState)placedOnState)) {
            return;
        }
        if (SymmetryWandItem.presentInHotbar((Player)player)) {
            return;
        }
        boolean creative = this.getBlock().equals(AllBlocks.CREATIVE_FLUID_TANK.get());
        FluidTankBlockEntity tankAt = null;
        if (creative) {
            tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)AllBlockEntityTypes.CREATIVE_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
        } else {
            tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)AllBlockEntityTypes.FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.ZINC_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.GOLDEN_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.ANDESITE_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.BRASS_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.IRON_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.NETHERITE_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.ROSE_GOLDEN_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.ROSARITE_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.VALKYRUM_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
            if (tankAt == null) {
                tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CreateMPNTBlockEntities.PYRAL_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
            }
        }
        if (tankAt == null) {
            return;
        }
        FluidTankBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = controllerBE.getWidth();
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        BlockPos blockPos = startPos = face == Direction.DOWN ? controllerBE.getBlockPos().below() : controllerBE.getBlockPos().above(controllerBE.getHeight());
        if (startPos.getY() != pos.getY()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.offset(xOffset, 0, zOffset);
                blockState = world.getBlockState(offsetPos);
                if (FluidTankBlock.isTank((BlockState)blockState)) continue;
                if (!blockState.canBeReplaced()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.isCreative() && stack.getCount() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.offset(xOffset, 0, zOffset);
                blockState = world.getBlockState(offsetPos);
                if (FluidTankBlock.isTank((BlockState)blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().putBoolean("SilenceTankSound", true);
                super.place(context);
                player.getPersistentData().remove("SilenceTankSound");
            }
        }
    }
}

