/*
 * Decompiled with CFR 0.152.
 */
package com.kitawadesu.create_mpnt.util.mixins;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelItem;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={FunnelItem.class})
public class FunnelItemMixin
extends BlockItem {
    private static final Set<Block> DISALLOWED_BLOCKS = Set.of((Block)AllBlocks.DEPOT.get());

    public FunnelItemMixin(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected BlockState getPlacementState(BlockPlaceContext ctx) {
        FunnelBlock funnelBlock;
        Block beltFunnelBlock;
        BlockState equivalentBeltFunnel;
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = super.getPlacementState(ctx);
        if (state == null || !(state.getBlock() instanceof FunnelBlock)) {
            return state;
        }
        Direction facing = (Direction)state.getValue((Property)FunnelBlock.FACING);
        BlockPos connectedPos = pos.relative(facing.getOpposite());
        BlockState connectedState = world.getBlockState(connectedPos);
        if (DISALLOWED_BLOCKS.contains(connectedState.getBlock())) {
            return null;
        }
        if (!facing.getAxis().isVertical() && BeltFunnelBlock.isOnValidBelt((BlockState)(equivalentBeltFunnel = (BlockState)(beltFunnelBlock = (funnelBlock = (FunnelBlock)this.getBlock()).getEquivalentBeltFunnel((BlockGetter)world, pos, state).getBlock()).getStateForPlacement(ctx).setValue((Property)BeltFunnelBlock.HORIZONTAL_FACING, (Comparable)facing)), (LevelReader)world, (BlockPos)pos)) {
            return equivalentBeltFunnel;
        }
        return state;
    }
}

