/*
 * Decompiled with CFR 0.152.
 */
package eva.ambidexterity.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.ambidexterity.AmbidexterityClient;
import eva.ambidexterity.config.AmbidexterityConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static File ambidexterityConfig;
    public static Gson configGson;

    public static void init() {
        JsonConfigHelper.createConfig();
        JsonConfigHelper.readFromConfig();
        JsonConfigHelper.writeToConfig();
    }

    public static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            boolean seemsValid;
            ambidexterityConfig = new File(folder, "ambidexterity.json");
            if (ambidexterityConfig.exists()) {
                try {
                    String ambidexterityConfigJson = Files.readString(Path.of(ambidexterityConfig.getPath(), new String[0]));
                    seemsValid = ambidexterityConfigJson.trim().startsWith("{");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                seemsValid = true;
            }
            if (!ambidexterityConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    AmbidexterityClient.LOGGER.info("Found invalid config file, creating new config file at './config/moreshieldvariants.json'.");
                }
                try {
                    ambidexterityConfig.createNewFile();
                    String json = configGson.toJson((Object)AmbidexterityConfig.getInstance());
                    FileWriter writer = new FileWriter(ambidexterityConfig);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void readFromConfig() {
        try {
            AmbidexterityConfig config = (AmbidexterityConfig)configGson.fromJson((Reader)new FileReader(ambidexterityConfig), AmbidexterityConfig.class);
            AmbidexterityConfig.getInstance().updateConfigs(config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToConfig() {
        try {
            String json = configGson.toJson((Object)AmbidexterityConfig.getInstance());
            FileWriter writer = new FileWriter(ambidexterityConfig, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        configGson = new GsonBuilder().setPrettyPrinting().create();
    }
}

