package eva.ambidexterity;

import eva.ambidexterity.access.ServerPlayerAccess;
import eva.ambidexterity.config.JsonConfigHelper;
import eva.ambidexterity.init.ParticleInit;
import eva.ambidexterity.network.AttackPayload;
import eva.ambidexterity.network.BalancePacket;
import eva.ambidexterity.network.HotHandPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmbidexterityMain implements ModInitializer {

    public static final String MOD_ID = "ambi";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static final class_2960 BALANCE_PACKET_ID = class_2960.method_43902("eva", "balance");
    public static final class_2960 ATTACK_PACKET_ID = class_2960.method_43902("eva", "off_attack");
    public static final class_2960 HOT_HAND_PACKET_ID = class_2960.method_43902("eva", "hot_hand");

    @Override
    public void onInitialize() {
        JsonConfigHelper.init();
        ParticleInit.initServer();

        PayloadTypeRegistry.configurationS2C().register(BalancePacket.TYPE, BalancePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(AttackPayload.TYPE, AttackPayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(HotHandPacket.TYPE, HotHandPacket.STREAM_CODEC);

        ServerPlayNetworking.registerGlobalReceiver(AttackPayload.TYPE, (payload, context) -> {
            int entityId = payload.entityId();
            context.server().execute(() -> {
                class_3222 tp = context.player();
                tp.method_14234();
                if (context.player().method_37908().method_8469(entityId) != null) {
                    ((ServerPlayerAccess) tp).dualWielding$attackOffhand(tp.method_37908().method_8469(entityId));
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(HotHandPacket.TYPE, (payload, context) -> {
            context.server().execute(() -> ((ServerPlayerAccess) context.player()).setOffhand(payload.offhand()));
        });
    }

    public static boolean isInverted(@Nullable class_1657 player) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return AmbidexterityClient.isInvertedInclToggle();
        } else {
            if (player == null) throw new NullPointerException("Player is null");
            return isServerInverted(player);
        }
    }

    private static boolean isServerInverted(class_1657 player) {
        if (player instanceof class_3222 serverPlayer) {
            return ((ServerPlayerAccess) serverPlayer).isOffhand();
        } else throw new ClassCastException("player is not instance of ServerPlayer");
    }
}