package eva.ambidexterity.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.InventoryAccess;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import net.minecraft.class_10630;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

import static eva.ambidexterity.AmbidexterityMain.isInverted;
import static net.minecraft.class_1661.method_7380;

@Mixin(class_1661.class)
public abstract class InventoryMixin implements class_1263, class_1275, InventoryAccess {

    @Shadow
    @Final
    @Mutable
    public static int SELECTION_SIZE;
    @Shadow
    @Final
    @Mutable
    public static int SLOT_OFFHAND;
    @Shadow
    @Final
    @Mutable
    public static int INVENTORY_SIZE;
    @Shadow
    @Final
    @Mutable
    public static Int2ObjectMap<class_1304> EQUIPMENT_SLOT_MAPPING;
    @Shadow
    @Final
    @Mutable
    private class_2371<class_1799> items;
    @Shadow
    private int selected;

    @Shadow @Final public class_1657 player;
    @Unique
    private class_1304 heldHand = null;
    @Unique
    private static final int HORSE_SHIFT = 5;
    @Unique
    private int offSelected;
    @Unique
    private final class_1661 inv = (class_1661) (Object) this;

    @Inject(
            method = "<clinit>",
            at = @At("TAIL")
    )
    private static void initializationChanges(CallbackInfo ci) {
        SELECTION_SIZE = 9;
        INVENTORY_SIZE = 36;
        SLOT_OFFHAND = 40;
        EQUIPMENT_SLOT_MAPPING = new Int2ObjectArrayMap<>(
                Map.of(
                        class_1304.field_6166.method_32320(INVENTORY_SIZE),
                        class_1304.field_6166,
                        class_1304.field_6172.method_32320(INVENTORY_SIZE),
                        class_1304.field_6172,
                        class_1304.field_6174.method_32320(INVENTORY_SIZE),
                        class_1304.field_6174,
                        class_1304.field_6169.method_32320(INVENTORY_SIZE),
                        class_1304.field_6169,
                        SLOT_OFFHAND,
                        class_1304.field_6171,
                        INVENTORY_SIZE + HORSE_SHIFT,
                        class_1304.field_48824,
                        INVENTORY_SIZE + HORSE_SHIFT + 1,
                        class_1304.field_55946
                )
        );
    }

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void reSizer(class_1657 player, class_10630 equipment, CallbackInfo ci) {
        this.items = class_2371.method_10213(INVENTORY_SIZE, class_1799.field_8037);
    }

    @ModifyConstant(
            method = "getSelectionSize",
            constant = @Constant(intValue = 9)
    )
    private static int tenSlots(int constant) {
        return SELECTION_SIZE;
    }

    @ModifyReturnValue(
            method = "isHotbarSlot",
            at = @At("RETURN")
    )
    private static boolean stillTenSlots(boolean original, @Local(argsOnly = true) int slot) {
        return slot >= -1 && slot < SELECTION_SIZE;
    }

    @ModifyConstant(
            method = "getSuitableHotbarSlot",
            constant = @Constant(
                    intValue = 9
            )
    )
    private int realSuitableSlot(int constant) {
        return SELECTION_SIZE;
    }

    @Inject(
            method = "setSelectedSlot",
            at = @At("HEAD"),
            cancellable = true
    )
    private void setSelectedSlot(int slot, CallbackInfo ci) {
        if (isInverted(null)) {
            this.setOffSelectedSlot(slot);
            ci.cancel();
            return;
        }
        if (slot == this.offSelected) {
            this.selected = -1;
            ci.cancel();
        } else {
            if (this.offSelected == -1) this.offSelected = this.selected;
        }
    }

    @Inject(
            method = "getSelectedItem",
            at = @At("HEAD"),
            cancellable = true
    )
    private void getSelectedItem(CallbackInfoReturnable<class_1799> cir) {
        if (selected == -1) {
            cir.setReturnValue(class_1799.field_8037);
            cir.cancel();
        }
    }

    @Inject(
            method = "getSelectedSlot",
            at = @At("HEAD"),
            cancellable = true
    )
    private void getSelectedSlot(CallbackInfoReturnable<Integer> cir) {
        if (selected == -1) {
            cir.setReturnValue(offSelected);
            cir.cancel();
        }
    }
    
    @Inject(
            method = "addAndPickItem",
            at = @At("HEAD"),
            cancellable = true
    )
    private void addAndPickItem(CallbackInfo ci, @Local(argsOnly = true) class_1799 itemStack) {
        if (isInverted(null)) {
            this.addAndPickOffItem(itemStack);
            ci.cancel();
        }
    }

    @Inject(
            method = "pickSlot",
            at = @At("HEAD"),
            cancellable = true
    )
    private void pickSlot(CallbackInfo ci, @Local(argsOnly = true) int index) {
        if (isInverted(null)) {
            this.pickOffSlot(index);
            ci.cancel();
        }
    }    
    @ModifyExpressionValue(
            method = "getSuitableHotbarSlot",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/player/Inventory;selected:I"
            )
    )
    private int suitableSlotFixer(int original) {
        return inv.method_67532();
    }

    @ModifyExpressionValue(
            method = "setSelectedItem",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/player/Inventory;selected:I"
            )
    )
    private int fixSlot(int original) {
        return inv.method_67532();
    }

    @Unique @Override
    public int getOffSelectedSlot() {
        if (offSelected == -1) return selected;
        return offSelected;
    }

    @Unique @Override
    public void setOffSelectedSlot(int slot) {
        if (slot == this.selected) {
            this.offSelected = -1;
        } else if (!method_7380(slot)) {
            throw new IllegalArgumentException("Invalid selected slot");
        } else {
            if (this.selected == -1) this.selected = this.offSelected;
            this.offSelected = slot;
        }
    }

    @Unique @Override
    public class_1799 getOffSelectedItem() {
        if (this.offSelected == -1) return class_1799.field_8037;
        return this.items.get(this.offSelected);
    }

    @Unique @Override
    public class_1799 setOffSelectedItem(class_1799 stack) {
        return this.items.set(this.getOffSelectedSlot(), stack);
    }

    @Unique @Override
    public void addAndPickOffItem(class_1799 stack) {
        this.setOffSelectedSlot(this.getOffSuitableHotbarSlot());
        if (!this.items.get(this.offSelected).method_7960()) {
            int i = inv.method_7376();
            if (i != -1) {
                this.items.set(i, this.items.get(this.offSelected));
            }
        }

        this.items.set(this.offSelected, stack);
    }

    @Unique @Override
    public void pickOffSlot(int index) {
        this.setOffSelectedSlot(this.getOffSuitableHotbarSlot());
        class_1799 itemStack = this.items.get(this.offSelected);
        this.items.set(this.offSelected, this.items.get(index));
        this.items.set(index, itemStack);
    }

    @Unique @Override
    public int getOffSuitableHotbarSlot() {
        for (int i = 0; i < SELECTION_SIZE; i++) {
            int j = (this.offSelected + i) % SELECTION_SIZE;
            if (this.items.get(j).method_7960()) {
                return j;
            }
        }

        for (int ix = 0; ix < SELECTION_SIZE; ix++) {
            int j = (this.offSelected + ix) % SELECTION_SIZE;
            if (!this.items.get(j).method_7942()) {
                return j;
            }
        }

        return this.offSelected;
    }

    @Unique @Override
    public boolean doHandSwap() {
        if (this.selected == -1 || this.offSelected == -1) {
//            if (inv.getSelectedItem().isEmpty()) {
//                this.heldHand = EquipmentSlot.OFFHAND;
//                this.selected = this.offSelected;
//                this.offSelected = this.offSelected + 1 % SELECTION_SIZE;
//                inv.setSelectedItem(this.getOffSelectedItem());
//                this.setOffSelectedItem(ItemStack.EMPTY);
//            } else {
//                this.heldHand = EquipmentSlot.MAINHAND;
//                this.offSelected = this.selected;
//                this.selected = this.selected + 1 % SELECTION_SIZE;
//                this.setOffSelectedItem(inv.getSelectedItem());
//                inv.setSelectedItem(ItemStack.EMPTY);
//            }
//            player.inventoryMenu.broadcastChanges();
            int temp = this.offSelected;
            this.offSelected = this.selected;
            this.selected = temp;
            player.method_6021();
            return true;
        }
        return false;
    }
//
//    @Unique @Override
//    public void tick() {
//        if (heldHand != null) {
//            switch (heldHand) {
//                case OFFHAND -> this.offSelected = -1;
//                case MAINHAND -> this.selected = -1;
//            }
//            heldHand = null;
//            player.inventoryMenu.broadcastChanges();
//        }
//    }
}
