/*
 * Decompiled with CFR 0.152.
 */
package eva.ambidexterity.config;

import eva.ambidexterity.config.enums.BalanceMode;
import eva.ambidexterity.config.enums.DefaultBehavior;
import eva.ambidexterity.network.BalancePacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class AmbidexterityConfig {
    private boolean updateDefault = true;
    private BalanceMode mode = BalanceMode.PRETTY_MUCH_BALANCED;
    private double dualDamageFactor = 0.8;
    private double twoHandedDamageFactor = 1.2;
    private double oneHandedDamageFactor = 1.0;
    private double dualSpeedFactor = 0.8;
    private double twoHandedSpeedFactor = 1.2;
    private double oneHandedSpeedFactor = 1.0;
    private DefaultBehavior defaultBehavior = DefaultBehavior.USE;
    private final List<String> invertList = new ArrayList<String>();
    private boolean invertWithCrouch = false;
    private boolean toggleInvert = false;
    private static final Set<class_2960> invertItems = ConcurrentHashMap.newKeySet();
    private static AmbidexterityConfig INSTANCE;
    private static AmbidexterityConfig SERVER_INSTANCE;

    public static AmbidexterityConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AmbidexterityConfig();
            AmbidexterityConfig.setInvertList(AmbidexterityConfig.def());
        }
        return INSTANCE;
    }

    public static AmbidexterityConfig getServerInstance() {
        return SERVER_INSTANCE;
    }

    void updateConfigs(AmbidexterityConfig config) {
        this.updateDefault = config.updateDefault;
        this.invertWithCrouch = config.invertWithCrouch;
        this.toggleInvert = config.toggleInvert;
        this.defaultBehavior = config.defaultBehavior;
        this.invertList.addAll(config.invertList);
        this.mode = config.mode;
        this.dualDamageFactor = config.dualDamageFactor;
        this.twoHandedDamageFactor = config.twoHandedDamageFactor;
        this.oneHandedDamageFactor = config.oneHandedDamageFactor;
        this.dualSpeedFactor = config.dualSpeedFactor;
        this.twoHandedSpeedFactor = config.twoHandedSpeedFactor;
        this.oneHandedSpeedFactor = config.oneHandedSpeedFactor;
        if (this.updateDefault) {
            if (this.defaultBehavior == DefaultBehavior.ATTACK) {
                this.defaultBehavior = DefaultBehavior.USE;
            }
            this.updateDefault = false;
        }
    }

    public double[] getValues() {
        return new double[]{this.dualDamageFactor, this.oneHandedDamageFactor, this.twoHandedDamageFactor, this.dualSpeedFactor, this.oneHandedSpeedFactor, this.twoHandedSpeedFactor};
    }

    public static void onBalanceReceived(BalancePacket payload) {
        AmbidexterityConfig.SERVER_INSTANCE.mode = payload.mode();
        if (SERVER_INSTANCE.getMode() == BalanceMode.CUSTOM_BALANCE) {
            double[] values = payload.values();
            AmbidexterityConfig.SERVER_INSTANCE.dualDamageFactor = values[0];
            AmbidexterityConfig.SERVER_INSTANCE.oneHandedDamageFactor = values[1];
            AmbidexterityConfig.SERVER_INSTANCE.twoHandedDamageFactor = values[2];
            AmbidexterityConfig.SERVER_INSTANCE.dualSpeedFactor = values[3];
            AmbidexterityConfig.SERVER_INSTANCE.oneHandedSpeedFactor = values[4];
            AmbidexterityConfig.SERVER_INSTANCE.twoHandedSpeedFactor = values[5];
        }
    }

    public DefaultBehavior getDefaultBehavior() {
        return this.defaultBehavior;
    }

    static void setDefaultBehavior(DefaultBehavior defaultBehavior) {
        AmbidexterityConfig.getInstance().defaultBehavior = defaultBehavior;
    }

    public BalanceMode getMode() {
        return this.mode;
    }

    static void setMode(BalanceMode mode) {
        AmbidexterityConfig.getInstance().mode = mode;
    }

    double getDualDamageFactor() {
        return this.dualDamageFactor;
    }

    static void setDualDamageFactor(double dualFactor) {
        AmbidexterityConfig.getInstance().dualDamageFactor = dualFactor;
    }

    double getTwoHandedDamageFactor() {
        return this.twoHandedDamageFactor;
    }

    static void setTwoHandedDamageFactor(double twoHandedFactor) {
        AmbidexterityConfig.getInstance().twoHandedDamageFactor = twoHandedFactor;
    }

    double getOneHandedDamageFactor() {
        return this.oneHandedDamageFactor;
    }

    static void setOneHandedDamageFactor(double oneHandedFactor) {
        AmbidexterityConfig.getInstance().oneHandedDamageFactor = oneHandedFactor;
    }

    double getDualSpeedFactor() {
        return this.dualSpeedFactor;
    }

    static void setDualSpeedFactor(double dualSpeedFactor) {
        AmbidexterityConfig.getInstance().dualSpeedFactor = dualSpeedFactor;
    }

    double getTwoHandedSpeedFactor() {
        return this.twoHandedSpeedFactor;
    }

    static void setTwoHandedSpeedFactor(double twoHandedSpeedFactor) {
        AmbidexterityConfig.getInstance().twoHandedSpeedFactor = twoHandedSpeedFactor;
    }

    double getOneHandedSpeedFactor() {
        return this.oneHandedSpeedFactor;
    }

    static void setOneHandedSpeedFactor(double oneHandedSpeedFactor) {
        AmbidexterityConfig.getInstance().oneHandedSpeedFactor = oneHandedSpeedFactor;
    }

    static List<String> getInvertList() {
        return new ArrayList<String>(AmbidexterityConfig.getInstance().invertList);
    }

    static void setInvertList(List<String> invertList) {
        AmbidexterityConfig.getInstance().invertList.clear();
        invertItems.clear();
        invertList.forEach(item -> invertItems.add(class_2960.method_12829((String)item)));
        invertItems.forEach(item -> AmbidexterityConfig.getInstance().invertList.add(item.toString()));
    }

    static Set<class_2960> getInvertItems() {
        return new HashSet<class_2960>(invertItems);
    }

    public static boolean isInvertWithCrouch() {
        return AmbidexterityConfig.getInstance().invertWithCrouch;
    }

    public static void setInvertWithCrouch(boolean invertWithCrouch) {
        AmbidexterityConfig.getInstance().invertWithCrouch = invertWithCrouch;
    }

    public static boolean isToggleInvert() {
        return AmbidexterityConfig.getInstance().toggleInvert;
    }

    public static void setToggleInvert(boolean toggleInvert) {
        AmbidexterityConfig.getInstance().toggleInvert = toggleInvert;
    }

    static Function<String, Optional<class_2561>> getErrorSupplier() {
        return new ErrorSupplier();
    }

    public static void disconnect() {
        if (SERVER_INSTANCE != null) {
            SERVER_INSTANCE = null;
        }
    }

    static List<String> def() {
        return List.of("minecraft:wooden_axe", "minecraft:golden_axe", "minecraft:stone_axe", "minecraft:iron_axe", "minecraft:diamond_axe", "minecraft:netherite_axe", "minecraft:wooden_shovel", "minecraft:golden_shovel", "minecraft:stone_shovel", "minecraft:iron_shovel", "minecraft:diamond_shovel", "minecraft:netherite_shovel", "minecraft:trident");
    }

    private static class ErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private ErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if ((entry = entry.toLowerCase()).indexOf(58) != entry.lastIndexOf(58)) {
                return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 1"));
            }
            String name = entry.substring(entry.indexOf(58) + 1).replaceAll("[^a-z0-9/._-]", "");
            if (!entry.equals(name)) {
                if (entry.indexOf(58) == -1) {
                    return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 2"));
                }
                String namespace = entry.substring(0, entry.indexOf(58)).replaceAll("[^a-z0-9/._-]", "");
                if (!entry.equals(namespace + ":" + name)) {
                    return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 3"));
                }
            }
            class_2960 id = class_2960.method_60654((String)entry);
            if (!class_7923.field_41178.method_10235().contains(id)) {
                return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 4"));
            }
            return Optional.empty();
        }
    }
}

