package eva.ambidexterity.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.BlockAccess;
import eva.ambidexterity.access.LivingEntityAccess;
import eva.ambidexterity.access.ServerPlayerGameModeAccess;
import net.minecraft.class_1268;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2846.class_2847;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3225.class)
public class ServerPlayerGameModeMixin implements ServerPlayerGameModeAccess {

    @Final @Shadow protected class_3222 player;
    @Shadow private int delayedTickStart;
    @Shadow private int destroyProgressStart;
    @Shadow private boolean hasDelayedDestroy;
    @Shadow private class_2338 delayedDestroyPos;
    @Shadow private class_2338 destroyPos;
    @Shadow private int lastSentState;
    @Shadow private boolean isDestroyingBlock;

    @Unique private final class_3225 spgm = (class_3225) (Object) this;

    @Inject(
            method = "tick",
            at = @At(value = "TAIL")
    )
    public void tick(CallbackInfo ci) {
        boolean varHolder = ((LivingEntityAccess) player).isOffhand();
        ((LivingEntityAccess) player).offhand(true);
        if (hasDelayedDestroy) {
            class_2680 blockState = this.player.method_51469().method_8320(delayedDestroyPos);
            if (blockState.method_26215()) {
                hasDelayedDestroy = false;
            } else {
                float f = spgm.method_21716(blockState, delayedDestroyPos, delayedTickStart);
                if (f >= 1.0F) {
                    hasDelayedDestroy = false;
                    spgm.method_14266(delayedDestroyPos);
                }
            }
        } else if (isDestroyingBlock) {
            class_2680 blockState = this.player.method_51469().method_8320(destroyPos);
            if (blockState.method_26215()) {
                this.player.method_51469().method_8517(player.method_5628(), destroyPos, -1);
                lastSentState = -1;
                isDestroyingBlock = false;
            } else {
                spgm.method_21716(blockState, destroyPos, destroyProgressStart);
            }
        }
        ((LivingEntityAccess) player).offhand(varHolder);
    }

    @Unique
    public void dualWielding$handleBlockBreakAction(class_2338 pos, class_2847 action, class_2350 direction, int worldHeight, int sequence) {
        boolean varHolder = this.isOffhand();
        this.offhand(true);
        spgm.method_14263(pos, action, direction, worldHeight, sequence);
        this.offhand(varHolder);
    }

    @ModifyExpressionValue(
            method = "handleBlockBreakAction",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/state/BlockState;getDestroyProgress(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F"
            )
    )
    private float destroyProgressReplacer(float original, @Local(argsOnly = true) class_2338 pos, @Local class_2680 blockState) {
        if (this.isOffhand())
            return ((BlockAccess) blockState).dualWielding$getDestroyProgress(player, this.player.method_51469(), pos);
        return original;
    }

    @Redirect(
            method = "handleBlockBreakAction",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/level/ServerPlayerGameMode;destroyAndAck(Lnet/minecraft/core/BlockPos;ILjava/lang/String;)V"
            )
    )
    private void redirectDestroyAndAck(class_3225 instance, class_2338 pos, int sequence, String message) {
        if (this.isOffhand()) this.dualWielding$destroyAndAck(pos, sequence, message);
        else instance.method_21717(pos, sequence, message);
    }

    @ModifyExpressionValue(
            method = "incrementDestroyProgress",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/state/BlockState;getDestroyProgress(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F"
            )
    )
    private float destroyProgressReplacer2(float original, @Local(argsOnly = true) class_2338 pos, @Local(argsOnly = true) class_2680 blockState) {
        if (this.isOffhand()) return ((BlockAccess) blockState).dualWielding$getDestroyProgress(player, this.player.method_51469(), pos);
        return original;
    }

    @ModifyExpressionValue(
            method = "useItemOn",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/InteractionHand;MAIN_HAND:Lnet/minecraft/world/InteractionHand;"
            )
    )
    private class_1268 useItemOn(class_1268 original, @Local(argsOnly = true) class_1268 hand) {
        return hand;
    }

    @Unique
    public void dualWielding$destroyAndAck(class_2338 pos, int sequence, String reason) {
        boolean varHolder = ((LivingEntityAccess) player).isOffhand();
        ((LivingEntityAccess) player).offhand(true);
        spgm.method_21717(pos, sequence, reason);
        ((LivingEntityAccess) player).offhand(varHolder);
    }

    @Unique
    private boolean isOffhand() {
        return ((LivingEntityAccess) player).isOffhand();
    }
    
    @Unique
    private void offhand(boolean val) {
        ((LivingEntityAccess) player).offhand(val);
    }
}
