package eva.ambidexterity;

import eva.ambidexterity.config.AmbidexterityConfig;
import eva.ambidexterity.config.enums.BalanceMode;
import eva.ambidexterity.network.BalancePacket;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmbidexterityServer implements DedicatedServerModInitializer {

    private static AmbidexterityConfig SERVER_INSTANCE;

    public static final class_2960 BALANCE_PACKET_ID = class_2960.method_43902("eva", "balance");


    public static final String MOD_ID = AmbidexterityMain.MOD_ID + "-server";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    @Override
    public void onInitializeServer() {

        SERVER_INSTANCE = AmbidexterityConfig.getInstance();

        ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend(handler, BalancePacket.ID)) {
                if (SERVER_INSTANCE.getMode() != BalanceMode.PRETTY_MUCH_BALANCED) {
                    LOGGER.info("sending balance");
                    if (SERVER_INSTANCE.getMode() == BalanceMode.CUSTOM_BALANCE)
                        handler.method_14364(ServerConfigurationNetworking.createS2CPacket(new BalancePacket(BalanceMode.CUSTOM_BALANCE, SERVER_INSTANCE.getValues())));
                    else handler.method_14364(ServerConfigurationNetworking.createS2CPacket(new BalancePacket(SERVER_INSTANCE.getMode())));

                }
            }
        });
    }
}
