package eva.ambidexterity.mixin;

import eva.ambidexterity.access.InventoryAccess;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import net.minecraft.class_10630;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

import static eva.ambidexterity.AmbidexterityClient.isInverted;
import static net.minecraft.class_1661.method_7380;

@Mixin(class_1661.class)
public abstract class InventoryMixin implements class_1263, class_1275, InventoryAccess {

    @Shadow
    @Final
    @Mutable
    public static int SELECTION_SIZE;
    @Shadow
    @Final
    @Mutable
    public static int SLOT_OFFHAND;
    @Shadow
    @Final
    @Mutable
    public static int INVENTORY_SIZE;
    @Shadow
    @Final
    @Mutable
    public static Int2ObjectMap<class_1304> EQUIPMENT_SLOT_MAPPING;
    @Shadow
    @Final
    @Mutable
    private class_2371<class_1799> items;
    @Shadow
    private int selected;

    @Unique
    private int offSelected;
    @Unique
    private final class_1661 inv = (class_1661) (Object) this;
    @Unique
    private static final int BASE = 40;

    @Inject(
            method = "<clinit>",
            at = @At("TAIL")
    )
    private static void initializationChanges(CallbackInfo ci) {
        SELECTION_SIZE = 10;
        SLOT_OFFHAND = -1;
        EQUIPMENT_SLOT_MAPPING = new Int2ObjectArrayMap<>(
                Map.of(
                        class_1304.field_6166.method_32320(BASE),
                        class_1304.field_6166,
                        class_1304.field_6172.method_32320(BASE),
                        class_1304.field_6172,
                        class_1304.field_6174.method_32320(BASE),
                        class_1304.field_6174,
                        class_1304.field_6169.method_32320(BASE),
                        class_1304.field_6169,
                        BASE + 4,
                        class_1304.field_48824,
                        BASE + 5,
                        class_1304.field_55946
                )
        );
        INVENTORY_SIZE = BASE;

    }

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void reSizer(class_1657 player, class_10630 equipment, CallbackInfo ci) {
        this.items = class_2371.method_10213(40, class_1799.field_8037);
    }

    @ModifyConstant(
            method = "getSelectionSize",
            constant = @Constant(intValue = 9)
    )
    private static int tenSlots(int constant) {
        return 10;
    }

    @ModifyConstant(
            method = "isHotbarSlot",
            constant = @Constant(intValue = 9)
    )
    private static int stillTenSlots(int constant) {
        return 10;
    }

    @ModifyConstant(
            method = "getSuitableHotbarSlot",
            constant = @Constant(
                    intValue = 9
            )
    )
    private int realSuitableSlot(int constant) {
        return 10;
    }

    @Inject(
            method = "setSelectedSlot",
            at = @At("HEAD"),
            cancellable = true
    )
    private void setSelectedSlot(int slot, CallbackInfo ci) {
        if (isInverted()) {
            this.setOffSelectedSlot(slot);
            ci.cancel();
            return;
        }
        if (slot == this.offSelected) {
            this.selected = -1;
            ci.cancel();
        } else {
            if (this.offSelected == -1) this.offSelected = this.selected;
        }
    }

    @Inject(
            method = "getSelectedItem",
            at = @At("HEAD"),
            cancellable = true
    )
    private void getSelectedItem(CallbackInfoReturnable<class_1799> cir) {
        if (selected == -1) {
            cir.setReturnValue(class_1799.field_8037);
            cir.cancel();
        }
    }

    @Inject(
            method = "getSelectedSlot",
            at = @At("HEAD"),
            cancellable = true
    )
    private void getSelectedSlot(CallbackInfoReturnable<Integer> cir) {
        if (selected == -1) {
            cir.setReturnValue(offSelected);
            cir.cancel();
        }
    }

    @Unique @Override
    public int getOffSelectedSlot() {
        if (offSelected == -1) return selected;
        return offSelected;
    }

    @Unique @Override
    public void setOffSelectedSlot(int slot) {
        if (slot == this.selected) {
            this.offSelected = -1;
        } else if (!method_7380(slot)) {
            throw new IllegalArgumentException("Invalid selected slot");
        } else {
            if (this.selected == -1) this.selected = this.offSelected;
            this.offSelected = slot;
        }
    }

    @Unique @Override
    public class_1799 getOffSelectedItem() {
        if (this.offSelected == -1) return class_1799.field_8037;
        return this.items.get(this.offSelected);
    }

    @Unique @Override
    public class_1799 setOffSelectedItem(class_1799 stack) {
        return this.items.set(this.offSelected, stack);
    }

    @Unique @Override
    public void addAndPickOffItem(class_1799 stack) {
        this.setOffSelectedSlot(this.getOffSuitableHotbarSlot());
        if (!this.items.get(this.offSelected).method_7960()) {
            int i = inv.method_7376();
            if (i != -1) {
                this.items.set(i, this.items.get(this.offSelected));
            }
        }

        this.items.set(this.offSelected, stack);
    }

    @Unique @Override
    public void pickOffSlot(int index) {
        this.setOffSelectedSlot(this.getOffSuitableHotbarSlot());
        class_1799 itemStack = this.items.get(this.offSelected);
        this.items.set(this.offSelected, this.items.get(index));
        this.items.set(index, itemStack);
    }

    @Unique @Override
    public int getOffSuitableHotbarSlot() {
        for (int i = 0; i < 10; i++) {
            int j = (this.offSelected + i) % 10;
            if (this.items.get(j).method_7960()) {
                return j;
            }
        }

        for (int ix = 0; ix < 10; ix++) {
            int j = (this.offSelected + ix) % 10;
            if (!this.items.get(j).method_7942()) {
                return j;
            }
        }

        return this.offSelected;
    }

//    @Inject(
//            method = "<init>",
//            at = @At("TAIL")
//    )
//    private void shiftSlots(Player player, EntityEquipment equipment, CallbackInfo ci) {
//        if (isSlotShift()) {
//            final Inventory inventory = player.getInventory();
//            ItemStack offhandItem = ItemStack.EMPTY;
//            for (int i = 40; i > 9; i--) {
//                if (i == 40) {
//                    offhandItem = player.getInventory().getItem(i);
//                    continue;
//                }
//                if (inventory.getItem(i).isEmpty()) continue;
//                inventory.setItem(i, inventory.getItem(i - 1));
//            }
//            inventory.setItem(9, offhandItem);
//            setSlotShift(false);
//        }
//    }

}
