package eva.ambidexterity.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.BlockAccess;
import eva.ambidexterity.access.LivingEntityAccess;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_4970.class)
public abstract class BlockBehaviourMixin implements BlockAccess {

    @Unique
    public float dualWielding$getDestroyProgress(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        boolean varHolder = ((LivingEntityAccess) player).isOffhand();
        ((LivingEntityAccess) player).offhand(true);
        float f = ((class_4970) (Object) this).method_9594(state, player, world, pos);
        ((LivingEntityAccess) player).offhand(varHolder);
        return f;
    }

    @Mixin(value = class_4970.class_4971.class, priority = 1)
    public abstract static class BlockStateBaseMixin implements BlockAccess {

        @Unique
        public float dualWielding$getDestroyProgress(class_1657 player, class_1922 world, class_2338 pos) {
            boolean varHolder = ((LivingEntityAccess) player).isOffhand();
            ((LivingEntityAccess) player).offhand(true);
            float f = ((class_4970.class_4971) (Object) this).method_26165(player, world, pos);
            ((LivingEntityAccess) player).offhand(varHolder);
            return f;
        }

        @ModifyExpressionValue(
                method = "getDestroyProgress",
                at = @At(
                        value = "INVOKE",
                        target = "Lnet/minecraft/world/level/block/Block;getDestroyProgress(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F"
                )
        )
        private float getDestroySpeed(float original, @Local(argsOnly = true) class_1657 player, @Local(argsOnly = true) class_1922 level, @Local(argsOnly = true) class_2338 pos) {
            if (((LivingEntityAccess) player).isOffhand()) return ((BlockAccess)((class_4970.class_4971) (Object) this).method_26204()).dualWielding$getDestroyProgress(this.shadow$asState(), player, level, pos);
            return original;
        }

        @Shadow
        protected abstract class_2680 shadow$asState();
    }

}
