package eva.ambidexterity.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.ambidexterity.access.InventoryAccess;
import eva.ambidexterity.access.LivingEntityAccess;
import eva.ambidexterity.access.PlayerAccess;
import eva.ambidexterity.init.ParticleInit;
import eva.ambidexterity.mixin.access.LivingEntityAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static eva.ambidexterity.config.ConfigInterpreter.modifyASpd;
import static eva.ambidexterity.config.ConfigInterpreter.modifyDamage;

@Mixin(class_1657.class)
public abstract class PlayerMixin extends LivingEntityMixin implements PlayerAccess {
    @Shadow
    @Final
    class_1661 inventory;
    @Unique
    private int offhandAttackStrengthTicker;
    @Unique
    private final class_1657 pe = (class_1657) (Object) this;
    @Unique
    private class_1799 lastItemInOffhand = class_1799.field_8037;

    @Inject(method = "tick()V", at = @At(value = "FIELD", target = "Lnet/minecraft/world/entity/player/Player;attackStrengthTicker:I", ordinal = 0))
    private void tickMixin(CallbackInfo info) {
        offhandAttackStrengthTicker++;
    }

    @Unique
    public void dualWielding$attackOffhand(class_1297 target) {
        boolean varHolder = ((LivingEntityAccess) pe).offhand(true);
        pe.method_7324(target);
        ((LivingEntityAccess) pe).offhand(varHolder);
    }

    @Inject(
            method = "getItemBySlot",
            at = @At("HEAD"),
            cancellable = true
    )
    private void mainHandStackChanger1(CallbackInfoReturnable<class_1799> cir, @Local(argsOnly = true) class_1304 slot) {
        if (slot.equals(class_1304.field_6173) && isOffhand()) {
            cir.setReturnValue(((class_1309) (Object) this).method_6079());
            cir.cancel();
        }
    }

    @ModifyReturnValue(
            method = "getItemBySlot",
            at = @At(
                    value = "RETURN",
                    ordinal = 1
            )
    )
    private class_1799 offhandItem(class_1799 original) {
        return ((InventoryAccess) this.inventory).getOffSelectedItem();
    }

    @Redirect(
            method = "setItemSlot",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/player/Inventory;selected:I",
                    opcode = Opcodes.GETFIELD
            )
    )
    private int slotCorrected(class_1661 inventory) {
        return ((InventoryAccess) inventory).getSelectedSlot();
    }

    @Redirect(
            method = "setItemSlot",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/core/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;",
                    ordinal = 1
            )
    )
    private <E> E setOffhandItem(class_2371<class_1799> instance, int i, E obj) {
        if (!(obj instanceof class_1799 stack)) throw new IllegalArgumentException();
        return (E) this.inventory.field_7547.set(((InventoryAccess) this.inventory).getOffSelectedSlot(), stack);
    }

    @Inject(
            method = "attack",
            at = @At("HEAD")
    )
    private void noInvulnerabilityForYou(class_1297 target, CallbackInfo ci) {
        if (target.field_6008 >= 17) {
            if (pe.method_7261(0.5F) >= 0.95F)
                target.field_6008 = 0;
        }
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 0
            )
    )
    private double attackAttributeGET(double original) {
        if (((LivingEntityAccess) pe).isOffhand())
            return ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_23721);
        return original;
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 mainHandChanger(class_1799 original) {
        return pe.method_59958();
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 1
            )
    )
    private double sweepingDamageRatioAttributeGET(double original) {
        if (((LivingEntityAccess) pe).isOffhand())
            return ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_51577);
        return original;
    }

    @ModifyExpressionValue(
            method = "sweepAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/core/particles/ParticleTypes;SWEEP_ATTACK:Lnet/minecraft/core/particles/SimpleParticleType;"
            )
    )
    private class_2400 sweepAttack2(class_2400 original) {
        if (((LivingEntityAccess) pe).isOffhand()) return ParticleInit.OFFHAND_SWEEPING;
        return original;
    }

    @ModifyArg(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;setItemInHand(Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;)V"
            )
    )
    private class_1268 handArgSwap(class_1268 hand) {
        if (((LivingEntityAccess) pe).isOffhand())
            return switch (hand) {
                case field_5808 -> class_1268.field_5810;
                case field_5810 -> class_1268.field_5808;
            };
        return hand;
    }

    @ModifyExpressionValue(
            method = "getDestroySpeed",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;)F"
            )
    )
    private float stackSwap(float original, @Local(argsOnly = true) class_2680 state) {
        if (((LivingEntityAccess) pe).isOffhand()) return pe.method_6079().method_7924(state);
        return original;
    }

    @ModifyExpressionValue(
            method = "getDestroySpeed",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 0
            )
    )
    private double miningEfficiencyAttributeGET(double original) {
        if (((LivingEntityAccess) pe).isOffhand()) return ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_51581);
        return original;
    }

    @ModifyExpressionValue(
            method = "getDestroySpeed",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 1
            )
    )
    private double blockBreakSpeedAttributeGET(double original) {
        if (((LivingEntityAccess) pe).isOffhand()) return ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_49076);
        return original;
    }

    @ModifyExpressionValue(
            method = "getDestroySpeed",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttribute(Lnet/minecraft/core/Holder;)Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;"
            )
    )
    private class_1324 submergedMiningSpeedAttributeGET(class_1324 original) {
        if (((LivingEntityAccess) pe).isOffhand()) return ((LivingEntityAccess) pe).offhandAttributes().method_45329(class_5134.field_51576);
        return original;
    }

    @Inject(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getMainHandItem()Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private void swapResetter(CallbackInfo ci) {
        class_1799 itemStack = pe.method_6079();
        if (!class_1799.method_7973(this.lastItemInOffhand, itemStack)) {
            if (!class_1799.method_7984(this.lastItemInOffhand, itemStack)) {
                boolean valHolder = ((LivingEntityAccess) pe).offhand(true);
                pe.method_7350();
                ((LivingEntityAccess) pe).offhand(valHolder);
            }

            this.lastItemInOffhand = itemStack.method_7972();
        }
    }

    @ModifyVariable(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;"
            ),
            ordinal = 3,
            name = "i"
    )
    private float fixDamage(float value) {
        return modifyDamage(value, pe);
    }

    @ModifyReturnValue(
            method = "getCurrentItemAttackStrengthDelay",
            at = @At("TAIL")
    )
    private float fixASpd(float value) {
        if (((LivingEntityAccess) pe).isOffhand()) return modifyASpd((float) ((double) 1.0F / ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_23723) * (double) 20.0F), pe, class_1268.field_5810);
        return modifyASpd(value, pe, class_1268.field_5808);
    }

    @Redirect(
            method = "resetAttackStrengthTicker",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/player/Player;attackStrengthTicker:I"
            )
    )
    private void tickerSetter(class_1657 instance, int value) {
        if (((LivingEntityAccess) pe).isOffhand()) this.offhandAttackStrengthTicker = 0;
        else ((LivingEntityAccessor) pe).setAttackStrengthTicker(0);
    }

    @ModifyExpressionValue(
            method = "getAttackStrengthScale",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/player/Player;attackStrengthTicker:I"
            )
    )
    private int tickerReplacer(int original) {
        if (((LivingEntityAccess) pe).isOffhand()) return this.offhandAttackStrengthTicker;
        return original;
    }

    @ModifyExpressionValue(
            method = "hasCorrectToolForDrops",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;getSelected()Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 toolSelector(class_1799 original) {
        if (((LivingEntityAccess) pe).isOffhand()) return pe.method_6079();
        return original;
    }
}
